/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.text.MessageFormat;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.osee.framework.ui.swt.Search;
import org.eclipse.osee.framework.ui.swt.SearchCCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SearchCellEditor
extends CellEditor {
    int selection;
    int maxDisplayed = 5;
    SearchCCombo comboBox;
    private Search searchControl;
    private static final int defaultStyle = 0;

    public SearchCellEditor() {
        this.setStyle(0);
    }

    public SearchCellEditor(Composite parent, String[] items) {
        this(parent, items, 0);
    }

    public SearchCellEditor(Composite parent, String[] items, int style) {
        super(parent, style);
        this.searchControl = new Search(items);
        this.setItems(items, true);
    }

    public String[] getItems() {
        return this.searchControl.getItems();
    }

    public void setItems(String[] items, boolean reset) {
        Assert.isNotNull((Object)items);
        this.populateComboBoxItems(items, reset);
    }

    public void setVisibleItemCount(int count) {
        this.comboBox.setVisibleItemCount(count);
    }

    public void setVisibleItemCount() {
        if (this.comboBox.getItemCount() > this.maxDisplayed) {
            this.setVisibleItemCount(this.maxDisplayed);
        } else {
            this.setVisibleItemCount(this.comboBox.getItemCount());
        }
        this.comboBox.redraw();
    }

    public void setMaxDisplayed(int max) {
        this.maxDisplayed = max;
        this.setVisibleItemCount();
    }

    public int getMaxDisplayed() {
        return this.maxDisplayed;
    }

    protected Control createControl(Composite parent) {
        this.comboBox = new SearchCCombo(parent, this.getStyle());
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                SearchCellEditor.this.keyReleaseOccured(e);
            }

            public void keyReleased(KeyEvent e) {
                SearchCellEditor.this.comboBox.setSelection(0, SearchCellEditor.this.searchControl.getLength());
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                SearchCellEditor.this.applyEditorValueAndDeactivate();
            }

            public void widgetSelected(SelectionEvent event) {
                SearchCellEditor.this.selection = SearchCellEditor.this.comboBox.getSelectionIndex();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.comboBox.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SearchCellEditor.this.focusLost();
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        if (this.searchControl.getFirstIndex() == -1) {
            return new Integer(this.selection);
        }
        return new Integer(this.selection + this.searchControl.getFirstIndex());
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    public CellEditor.LayoutData getLayoutData() {
        CellEditor.LayoutData layoutData = super.getLayoutData();
        if (this.comboBox == null || this.comboBox.isDisposed()) {
            layoutData.minimumWidth = 60;
        } else {
            GC gc = new GC((Drawable)this.comboBox);
            layoutData.minimumWidth = gc.getFontMetrics().getAverageCharWidth() * 10 + 10;
            gc.dispose();
        }
        return layoutData;
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.comboBox != null && (value instanceof Integer || value instanceof String) ? 1 : 0) != 0);
        if (value instanceof Integer) {
            this.selection = (Integer)value;
            this.comboBox.select(this.selection);
        } else if (value instanceof String) {
            this.comboBox.setText((String)value);
        }
    }

    private void populateComboBoxItems(String[] items, boolean reset) {
        if (this.comboBox != null && items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < items.length) {
                this.comboBox.add(items[i], i);
                ++i;
            }
            this.setValueValid(true);
            this.setVisibleItemCount();
            if (reset) {
                this.selection = 0;
            }
        }
    }

    void applyEditorValueAndDeactivate() {
        this.selection = this.comboBox.getSelectionIndex();
        Object newValue = this.doGetValue();
        this.markDirty();
        boolean isValid = this.isCorrect(newValue);
        this.setValueValid(isValid);
        if (!isValid) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), this.searchControl.getItems()[this.selection]));
        }
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void focusLost() {
        if (this.isActivated()) {
            this.applyEditorValueAndDeactivate();
        }
        this.selection = (Integer)this.doGetValue();
        this.searchControl.reset();
        this.setItems(this.searchControl.getItems(), false);
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\u001b') {
            this.fireCancelEditor();
        } else if (keyEvent.character == '\t') {
            this.applyEditorValueAndDeactivate();
        } else if (keyEvent.character != '\u0000') {
            this.searchControl.progressiveSearch(keyEvent);
            if (this.searchControl.getDirty()) {
                this.setItems(this.searchControl.getItems(), true);
                this.comboBox.select(this.selection);
                this.comboBox.updateWidget();
                this.comboBox.setSelection(0, this.searchControl.getLength());
                this.searchControl.setDirty(false);
            }
        }
    }
}

