/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.change;

import java.util.StringTokenizer;
import org.eclipse.osee.framework.core.data.ApplicabilityToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;

public class TupleChange
extends Change {
    private final String isValue;
    private final String wasValue;
    private final String itemKind;
    private final TupleTypeId itemTypeId;
    private String itemTypeDescription;
    private String detailedIsValue;
    private String detailedWasValue;

    public TupleChange(BranchToken branch, GammaId sourceGamma, TransactionDelta txDelta, ModificationType modType, TupleTypeId itemTypeId, String isValue, String wasValue, String itemKind, boolean isHistorical) {
        super(branch, sourceGamma, ArtifactId.valueOf((Long)0L), txDelta, modType, isHistorical, Artifact.SENTINEL, null);
        this.itemTypeId = itemTypeId;
        this.itemKind = itemKind;
        this.isValue = isValue;
        this.wasValue = wasValue;
        if (this.getItemTypeId().getId().equals(CoreTupleTypes.ViewApplicability.getId()) || this.getItemTypeId().getId().equals(CoreTupleTypes.ApplicabilityDefinition.getId())) {
            String cfg;
            String value = isValue.isEmpty() ? wasValue : isValue;
            StringTokenizer tok = new StringTokenizer(value, ",");
            String cfgId = "";
            String appId = "";
            if (tok.hasMoreTokens()) {
                cfgId = tok.nextToken();
            }
            if (tok.hasMoreElements()) {
                appId = tok.nextToken().trim();
            }
            if ((cfg = ServiceUtil.getOseeClient().getApplicabilityEndpoint((BranchId)this.getBranch()).getView(cfgId).getName()).isEmpty()) {
                cfg = ServiceUtil.getOseeClient().getApplicabilityEndpoint((BranchId)this.getBranch()).getConfigurationGroup(cfgId).getName();
            }
            if (cfg.isEmpty()) {
                cfg = ServiceUtil.getOseeClient().getApplicabilityEndpoint((BranchId)this.getBranch()).getFeature(cfgId).getName();
            }
            ApplicabilityToken tag = ServiceUtil.getOseeClient().getApplicabilityEndpoint((BranchId)this.getBranch()).getApplicabilityTokenFromId(appId);
            this.itemTypeDescription = cfg;
            if (isValue.isEmpty()) {
                this.detailedWasValue = tag.getName();
                this.detailedIsValue = isValue;
            } else {
                this.detailedIsValue = tag.getName();
                this.detailedWasValue = wasValue;
            }
        }
    }

    public TupleTypeId getItemTypeId() {
        return this.itemTypeId;
    }

    @Override
    public String getIsValue() {
        if (this.getItemTypeId().getId().equals(CoreTupleTypes.ViewApplicability.getId()) || this.getItemTypeId().getId().equals(CoreTupleTypes.ApplicabilityDefinition.getId())) {
            return this.detailedIsValue;
        }
        return this.isValue;
    }

    @Override
    public String getWasValue() {
        if (this.getItemTypeId().getId().equals(CoreTupleTypes.ViewApplicability.getId()) || this.getItemTypeId().getId().equals(CoreTupleTypes.ApplicabilityDefinition.getId())) {
            return this.detailedWasValue;
        }
        return this.wasValue;
    }

    @Override
    public String getItemTypeName() {
        if (this.getItemTypeId().getId().equals(CoreTupleTypes.ViewApplicability.getId()) || this.getItemTypeId().getId().equals(CoreTupleTypes.ApplicabilityDefinition.getId())) {
            return this.itemTypeDescription;
        }
        return this.itemTypeId.getIdString();
    }

    @Override
    public String getName() {
        if (this.getItemTypeId().getId().equals(CoreTupleTypes.ViewApplicability.getId()) || this.getItemTypeId().getId().equals(CoreTupleTypes.ApplicabilityDefinition.getId())) {
            return "Product Line Configuration";
        }
        return "N/A";
    }

    @Override
    public String getNameOrToken() {
        return this.getName();
    }

    @Override
    public String getItemKind() {
        return this.itemKind;
    }

    @Override
    public Id getItemId() {
        return this.getGamma();
    }

    @Override
    public ChangeType getChangeType() {
        return ChangeType.Tuple;
    }

    public String getItemTypeDescription() {
        return this.itemTypeDescription;
    }

    public void setItemTypeDescription(String itemTypeDescription) {
        this.itemTypeDescription = itemTypeDescription;
    }

    public String getDetailedWasValue() {
        return this.detailedWasValue;
    }

    public void setDetailedWasValue(String detailedWasValue) {
        this.detailedWasValue = detailedWasValue;
    }

    public String getDetailedIsValue() {
        return this.detailedIsValue;
    }

    public void setDetailedIsValue(String detailedIsValue) {
        this.detailedIsValue = detailedIsValue;
    }
}

