/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.transaction.BaseTransactionData;
import org.eclipse.osee.orcs.rest.model.ResourcesEndpoint;

public class AttributeTransactionData
extends BaseTransactionData {
    private static final String INSERT_ATTRIBUTE = "INSERT INTO osee_attribute (art_id, attr_id, attr_type_id, value, gamma_id, uri) VALUES (?, ?, ?, ?, ?, ?)";
    private final Attribute<?> attribute;
    private final DAOToSQL daoToSql;

    public AttributeTransactionData(Attribute<?> attribute) {
        super((Id)attribute, attribute.getModificationType());
        this.attribute = attribute;
        this.daoToSql = new DAOToSQL(new Object[0]);
    }

    public Attribute<?> getAttribute() {
        return this.attribute;
    }

    @Override
    public OseeSql getSelectTxNotCurrentSql() {
        return OseeSql.TX_GET_PREVIOUS_TX_NOT_CURRENT_ATTRIBUTES;
    }

    @Override
    protected void addInsertToBatch(BaseTransactionData.InsertDataCollector collector) {
        super.addInsertToBatch(collector);
        if (!this.attribute.isUseBackingData()) {
            this.attribute.getAttributeDataProvider().persist(this.getGammaId());
            this.daoToSql.setData(this.attribute.getAttributeDataProvider().getData());
            this.internalAddInsertToBatch(collector, 3, INSERT_ATTRIBUTE, new Object[]{this.attribute.getArtifact(), this.getItemId(), this.attribute.getAttributeType().getId(), this.daoToSql.getValue(), this.getGammaId(), this.daoToSql.getUri()});
        }
    }

    @Override
    protected void internalUpdate(TransactionRecord transaction) {
        this.attribute.internalSetGammaId(this.getGammaId());
        this.attribute.getArtifact().setTransactionId(transaction);
    }

    @Override
    protected void internalClearDirtyState() {
        this.attribute.setNotDirty();
    }

    @Override
    protected void internalOnRollBack() {
        if (!this.attribute.isUseBackingData() && Strings.isValid((String)this.daoToSql.getUri())) {
            try {
                OseeClient client = ServiceUtil.getOseeClient();
                ResourcesEndpoint endpoint = client.getResourcesEndpoint();
                endpoint.deleteResource(this.asPath(this.daoToSql.getUri()));
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
    }

    private String asPath(String uri) {
        String toReturn = uri;
        if (Strings.isValid((String)toReturn)) {
            toReturn = toReturn.replaceAll("://", "/");
        }
        return toReturn;
    }

    @Override
    protected GammaId createGammaId() {
        return this.attribute.isUseBackingData() ? this.attribute.getGammaId() : this.getNextGammaIdFromSequence();
    }

    @Override
    protected void internalAddToEvents(ArtifactEvent artifactEvent) {
    }

    @Override
    protected ApplicabilityId getApplicabilityId() {
        return this.attribute.getApplicabilityId();
    }

    private static final class DAOToSQL {
        private String uri;
        private String value;

        public DAOToSQL(Object ... data) {
            if (data != null) {
                this.setData(data);
            } else {
                this.uri = null;
                this.value = null;
            }
        }

        public void setData(Object ... data) {
            this.uri = this.getItemAt(1, data);
            this.value = this.getItemAt(0, data);
        }

        private String getItemAt(int index, Object ... data) {
            Object obj;
            String toReturn = null;
            if (data != null && data.length > index && (obj = data[index]) != null) {
                toReturn = obj.toString();
            }
            return toReturn;
        }

        public String getUri() {
            return this.uri != null ? this.uri : "";
        }

        public String getValue() {
            return this.value != null ? this.value : "";
        }
    }
}

