/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.skynet.core.artifact.search.ISearchPrimitive;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;

public class ArtifactTypeSearch
implements ISearchPrimitive {
    private final List<ArtifactTypeToken> artifactTypes;

    public ArtifactTypeSearch(List<ArtifactTypeToken> artifactTypes) {
        this.artifactTypes = artifactTypes;
    }

    public String toString() {
        return "Artifact type: " + this.artifactTypes.toString();
    }

    @Override
    public String getStorageString() {
        StringBuilder storageString = new StringBuilder();
        for (ArtifactTypeToken a : this.artifactTypes) {
            storageString.append(a.getIdString());
            storageString.append(",");
        }
        storageString.deleteCharAt(storageString.length() - 1);
        return storageString.toString();
    }

    public static ArtifactTypeSearch getPrimitive(String storageString) {
        ArrayList<ArtifactTypeToken> artifactTypes = new ArrayList<ArtifactTypeToken>();
        String[] stringArray = storageString.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String artifactTypeId = stringArray[n2];
            artifactTypes.add(ArtifactTypeToken.valueOf((long)Long.parseLong(artifactTypeId), (String)"SearchArtType", (ArtifactTypeToken[])new ArtifactTypeToken[0]));
            ++n2;
        }
        return new ArtifactTypeSearch(artifactTypes);
    }

    @Override
    public void addToQuery(QueryBuilderArtifact builder) {
        builder.andIsOfType(this.artifactTypes);
    }
}

