/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class UnitTestUtil {
    private static final Pattern testMethodPattern = Pattern.compile("(@Test|@org.junit.Test)");
    private static final Pattern extendsPattern = Pattern.compile("class (.*) extends (.*) ");

    public static boolean isUnitTest(File file) throws IOException {
        String text = Lib.fileToString((File)file);
        return UnitTestUtil.isUnitTest(text);
    }

    public static boolean isUnitTest(String fileContents) {
        return fileContents.contains("@Test") || fileContents.contains("@org.junit.Test");
    }

    public static boolean isSuite(File file) {
        return file.getAbsolutePath().endsWith(".java") && file.getName().contains("Suite");
    }

    public static boolean isTestUtil(File file) {
        return file.getAbsolutePath().endsWith(".java") && file.getName().contains("Util");
    }

    public static boolean isMock(File file) {
        return file.getAbsolutePath().endsWith(".java") && file.getName().contains("Mock");
    }

    public static Set<String> getAuthors(File file) throws IOException {
        String text = Lib.fileToString((File)file);
        return UnitTestUtil.getAuthors(text);
    }

    public static Set<String> getAuthors(String fileContents) {
        HashSet<String> authors = new HashSet<String>();
        String[] stringArray = fileContents.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains("* @author")) {
                String author = line;
                author = author.replaceAll(":", "");
                author = author.replaceAll(System.getProperty("line.separator"), "");
                author = author.replaceFirst("^.*@author *", "");
                author = author.replaceFirst(" *$", "");
                if (Strings.isValid((String)(author = author.replaceAll("\\s+$", "")))) {
                    authors.add(author);
                }
            }
            ++n2;
        }
        return authors;
    }

    public static int getTestMethodCount(String fileContents) {
        Matcher m = testMethodPattern.matcher(fileContents);
        int fileTestPointCount = 0;
        while (m.find()) {
            ++fileTestPointCount;
        }
        return fileTestPointCount;
    }

    public static int getTestMethodCountFromSuperclass(File file, String text) throws IOException {
        String fullPath;
        File superFile;
        String superClassName;
        Matcher m = extendsPattern.matcher(text);
        if (m.find() && Strings.isValid((String)(superClassName = m.group(2))) && (superFile = new File((fullPath = file.getAbsolutePath()).replaceFirst(file.getName(), String.valueOf(superClassName) + ".java"))).exists()) {
            return UnitTestUtil.getTestMethodCount(Lib.fileToString((File)superFile));
        }
        return 0;
    }
}

