/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.logging;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import org.eclipse.osee.framework.jdk.core.util.OseeProperties;
import org.eclipse.osee.framework.logging.ConsoleLogger;
import org.eclipse.osee.framework.logging.ILoggerListener;

public class OseeLogger {
    private final List<ILoggerListener> listeners;
    private final Map<String, Level> levelMap = new ConcurrentHashMap<String, Level>();
    private final Level defaultLevel;

    public OseeLogger() {
        this.listeners = new CopyOnWriteArrayList<ILoggerListener>();
        this.listeners.add(new ConsoleLogger());
        this.defaultLevel = OseeProperties.getOseeLogDefault();
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            if (!entry.getKey().toString().startsWith("osee.log.")) continue;
            String name = entry.getKey().toString().substring(9);
            String level = entry.getValue().toString();
            try {
                Level lev = Level.parse(level);
                this.levelMap.put(name, lev);
            }
            catch (Exception exception) {}
        }
    }

    public void log(String loggerName, Level level, String message, Throwable th) {
        if (!this.shouldLog(loggerName, level)) {
            return;
        }
        for (ILoggerListener logger : this.listeners) {
            logger.log(loggerName, level, message, th);
        }
    }

    public void format(String loggerName, Level level, String message, Object ... objects) {
        this.format(null, loggerName, level, message, objects);
    }

    public void format(Throwable th, String loggerName, Level level, String message, Object ... objects) {
        if (!this.shouldLog(loggerName, level)) {
            return;
        }
        for (ILoggerListener logger : this.listeners) {
            String msg = String.format(message, objects);
            logger.log(loggerName, level, msg, th);
        }
    }

    public void registerLoggerListener(ILoggerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void unregisterLoggerListener(ILoggerListener listener) {
        this.listeners.remove(listener);
    }

    public void setLevel(String loggerName, Level level) {
        this.levelMap.put(loggerName, level);
    }

    private boolean shouldLog(String loggerName, Level level) {
        Level filterLevel = this.levelMap.get(loggerName);
        if (filterLevel == null) {
            filterLevel = this.defaultLevel;
            this.levelMap.put(loggerName, filterLevel);
        }
        return level.intValue() >= filterLevel.intValue();
    }
}

