/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.osee.ote.ui.define.reports.ITestRunReport;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ExtensionDefinedReports {
    private static final String EXTENSION_ID = "ITestRunReport";
    private final Map<String, ReportData> reportMap = new HashMap<String, ReportData>();
    private Map<String, Pair<String, String>> idsAndNameMap;
    private static ExtensionDefinedReports instance = null;

    private ExtensionDefinedReports() {
        this.loadReports();
    }

    public static ExtensionDefinedReports getInstance() {
        if (instance == null) {
            instance = new ExtensionDefinedReports();
        }
        return instance;
    }

    public Pair<String, String>[] getIdsAndNames() {
        if (this.idsAndNameMap == null) {
            this.idsAndNameMap = new HashMap<String, Pair<String, String>>();
            Set<String> ids = this.reportMap.keySet();
            for (String id : ids) {
                ReportData data = this.reportMap.get(id);
                this.idsAndNameMap.put(id, (Pair<String, String>)new Pair((Object)id, (Object)data.getName()));
            }
        }
        return this.idsAndNameMap.values().toArray(new Pair[this.idsAndNameMap.size()]);
    }

    public Image getImage(String key) {
        ReportData data = this.reportMap.get(key);
        Image toReturn = data.getIcon();
        return toReturn != null ? toReturn : ImageManager.getImage((KeyedImage)ImageManager.MISSING);
    }

    public ITestRunReport getReportGenerator(String key) {
        ReportData data = this.reportMap.get(key);
        return data != null ? data.getTestRunReport() : null;
    }

    public Pair<String, String> getIdAndName(String id) {
        return this.idsAndNameMap.get(id);
    }

    private void loadReports() {
        List elements = ExtensionPoints.getExtensionElements((Plugin)Activator.getInstance(), (String)EXTENSION_ID, (String)EXTENSION_ID);
        for (IConfigurationElement element : elements) {
            IExtension extension = (IExtension)element.getParent();
            String identifier = extension.getUniqueIdentifier();
            String name = extension.getLabel();
            String className = element.getAttribute("classname");
            String iconName = element.getAttribute("icon");
            String bundleName = element.getContributor().getName();
            if (!Strings.isValid((String)bundleName) || !Strings.isValid((String)className)) continue;
            try {
                Bundle bundle = Platform.getBundle((String)bundleName);
                Class taskClass = bundle.loadClass(className);
                ITestRunReport object = (ITestRunReport)taskClass.newInstance();
                if (object == null) continue;
                URL url = bundle.getEntry(iconName);
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
                this.reportMap.put(identifier, new ReportData(identifier, name, object, imageDescriptor.createImage()));
            }
            catch (Exception ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error loading report [%s]", (Object[])new Object[]{className});
            }
        }
    }

    private final class ReportData {
        private final String name;
        private final Image icon;
        private final ITestRunReport testRunReport;

        public ReportData(String id, String name, ITestRunReport testRunReport, Image icon) {
            this.name = name;
            this.icon = icon;
            this.testRunReport = testRunReport;
        }

        public String getName() {
            return this.name;
        }

        public Image getIcon() {
            return this.icon;
        }

        public ITestRunReport getTestRunReport() {
            return this.testRunReport;
        }
    }
}

