/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserText;
import org.eclipse.ui.internal.browser.BusyIndicator;
import org.eclipse.ui.internal.browser.IBrowserViewerContainer;
import org.eclipse.ui.internal.browser.ImageResourceManager;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.ToolbarLayout;
import org.eclipse.ui.internal.browser.Trace;
import org.eclipse.ui.internal.browser.WebBrowserPreference;
import org.eclipse.ui.internal.browser.WebBrowserUIPlugin;
import org.eclipse.ui.internal.browser.WebBrowserUtil;
import org.eclipse.urischeme.IUriSchemeProcessor;

public class BrowserViewer
extends Composite {
    public static final int LOCATION_BAR = 2;
    public static final int BUTTON_BAR = 4;
    protected static final String PROPERTY_TITLE = "title";
    private static final int MAX_HISTORY = 50;
    public Clipboard clipboard;
    public Combo combo;
    protected boolean showToolbar;
    protected boolean showURLbar;
    protected ToolItem back;
    protected ToolItem forward;
    protected MenuItem autoRefresh;
    protected BusyIndicator busy;
    protected boolean loading;
    protected static List<String> history;
    protected Browser browser;
    protected BrowserText text;
    protected boolean newWindow;
    protected IBrowserViewerContainer container;
    protected String title;
    protected int progressWorked = 0;
    protected WatchService watcher;
    protected List<PropertyChangeListener> propertyListeners;
    public ILocationListener locationListener;
    public IBackNextListener backNextListener;
    private ImageResourceManager imageManager;
    private static final String URL_PREFIX = "$nl$/icons/";
    private static final String URL_ELCL = "$nl$/icons/elcl16/";
    private static final String URL_CLCL = "$nl$/icons/clcl16/";
    private static final String URL_DLCL = "$nl$/icons/dlcl16/";
    protected File file;
    protected long timestamp;
    protected Thread fileListenerThread;
    protected LocationListener locationListener2;
    protected Object syncObject = new Object();

    public BrowserViewer(Composite parent, int style) {
        super(parent, 0);
        if ((style & 2) != 0) {
            this.showURLbar = true;
        }
        if ((style & 4) != 0) {
            this.showToolbar = true;
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.clipboard = new Clipboard(parent.getDisplay());
        if (this.showToolbar || this.showURLbar) {
            Composite toolbarComp = new Composite((Composite)this, 0);
            this.imageManager = new ImageResourceManager((Control)toolbarComp);
            toolbarComp.setLayout((Layout)new ToolbarLayout());
            toolbarComp.setLayoutData((Object)new GridData(770));
            if (this.showToolbar) {
                this.createToolbar(toolbarComp);
            }
            if (this.showURLbar) {
                this.createLocationBar(toolbarComp);
            }
            if (this.showToolbar | this.showURLbar) {
                this.busy = new BusyIndicator(toolbarComp, 0);
                this.busy.setLayoutData(new GridData(128));
                this.busy.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        BrowserViewer.this.setURL("http://www.eclipse.org");
                    }
                });
            }
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this, "org.eclipse.ui.browser.browser_context");
        }
        try {
            this.browser = new Browser((Composite)this, 0);
            this.browser.addLocationListener(LocationListener.changingAdapter(event -> {
                URI uri = URI.create(event.location);
                if (!(uri.getScheme().equals("http") || uri.getScheme().equals("https") || uri.getScheme().equals("file"))) {
                    try {
                        if (IUriSchemeProcessor.INSTANCE.canHandle(uri)) {
                            IUriSchemeProcessor.INSTANCE.handleUri(uri);
                            event.doit = false;
                        }
                    }
                    catch (CoreException e) {
                        WebBrowserUIPlugin.logError(e.getMessage(), e);
                    }
                }
            }));
        }
        catch (SWTError e) {
            if (e.code != 2) {
                WebBrowserUtil.openError(Messages.errorCouldNotLaunchInternalWebBrowser);
                return;
            }
            this.text = new BrowserText(this, this, e);
        }
        if (this.showURLbar) {
            this.updateHistory();
        }
        if (this.showToolbar) {
            this.updateBackNextBusy();
        }
        if (this.browser != null) {
            this.browser.setLayoutData((Object)new GridData(1808));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.browser, "org.eclipse.ui.browser.browser_context");
        } else {
            this.text.getControl().setLayoutData((Object)new GridData(1808));
        }
        this.addBrowserListeners();
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void home() {
        this.browser.setText("");
    }

    public void setURL(String url) {
        this.setURL(url, true);
    }

    protected void updateBackNextBusy() {
        if (!this.back.isDisposed()) {
            this.back.setEnabled(this.isBackEnabled());
        }
        if (!this.forward.isDisposed()) {
            this.forward.setEnabled(this.isForwardEnabled());
        }
        if (!this.busy.isDisposed()) {
            this.busy.setBusy(this.loading);
        }
        if (this.backNextListener != null) {
            this.backNextListener.updateBackNextBusy();
        }
    }

    protected void updateLocation() {
        if (this.locationListener != null) {
            this.locationListener.historyChanged(null);
        }
        if (this.locationListener != null) {
            this.locationListener.locationChanged(null);
        }
    }

    private void addBrowserListeners() {
        if (this.browser == null) {
            return;
        }
        this.browser.addStatusTextListener(event -> {
            if (this.container != null) {
                IStatusLineManager status = this.container.getActionBars().getStatusLineManager();
                status.setMessage(event.text);
            }
        });
        this.browser.addOpenWindowListener(event -> {
            Shell shell2 = new Shell(this.getShell(), 1264);
            shell2.setLayout((Layout)new FillLayout());
            shell2.setText(Messages.viewWebBrowserTitle);
            shell2.setImage(this.getShell().getImage());
            if (event.location != null) {
                shell2.setLocation(event.location);
            }
            if (event.size != null) {
                shell2.setSize(event.size);
            }
            int style = 0;
            if (this.showURLbar) {
                style += 2;
            }
            if (this.showToolbar) {
                style += 4;
            }
            BrowserViewer browser2 = new BrowserViewer((Composite)shell2, style);
            browser2.newWindow = true;
            event.browser = browser2.browser;
        });
        this.browser.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){

            public void show(WindowEvent e) {
                Browser browser2 = (Browser)e.widget;
                if (browser2.getParent().getParent() instanceof Shell) {
                    Shell shell = (Shell)browser2.getParent().getParent();
                    if (e.location != null) {
                        shell.setLocation(e.location);
                    }
                    if (e.size != null) {
                        shell.setSize(shell.computeSize(e.size.x, e.size.y));
                    }
                    shell.open();
                }
            }
        });
        this.browser.addCloseWindowListener(event -> {
            if (this.newWindow) {
                this.getShell().dispose();
            } else {
                this.container.close();
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event) {
                if (event.total == 0) {
                    return;
                }
                boolean done = event.current == event.total;
                int percentProgress = event.current * 100 / event.total;
                if (BrowserViewer.this.container != null) {
                    IProgressMonitor monitor = BrowserViewer.this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                    if (done) {
                        monitor.done();
                        BrowserViewer.this.progressWorked = 0;
                    } else if (BrowserViewer.this.progressWorked == 0) {
                        monitor.beginTask("", event.total);
                        BrowserViewer.this.progressWorked = percentProgress;
                    } else {
                        monitor.worked(event.current - BrowserViewer.this.progressWorked);
                        BrowserViewer.this.progressWorked = event.current;
                    }
                }
                if (BrowserViewer.this.showToolbar) {
                    if (!BrowserViewer.this.busy.isBusy() && !done) {
                        BrowserViewer.this.loading = true;
                    } else if (BrowserViewer.this.busy.isBusy() && done) {
                        BrowserViewer.this.loading = false;
                    }
                    BrowserViewer.this.updateBackNextBusy();
                    BrowserViewer.this.updateHistory();
                }
            }

            public void completed(ProgressEvent event) {
                if (BrowserViewer.this.container != null) {
                    IProgressMonitor monitor = BrowserViewer.this.container.getActionBars().getStatusLineManager().getProgressMonitor();
                    monitor.done();
                }
                if (BrowserViewer.this.showToolbar) {
                    BrowserViewer.this.loading = false;
                    BrowserViewer.this.updateBackNextBusy();
                    BrowserViewer.this.updateHistory();
                }
            }
        });
        if (this.showURLbar) {
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent event) {
                    if (!event.top) {
                        return;
                    }
                    if (BrowserViewer.this.combo != null && !"about:blank".equals(event.location)) {
                        BrowserViewer.this.combo.setText(event.location);
                        BrowserViewer.this.addToHistory(event.location);
                        BrowserViewer.this.updateHistory();
                    }
                    if (BrowserViewer.this.showToolbar) {
                        File temp = BrowserViewer.getFile(BrowserViewer.this.browser.getUrl());
                        if (temp != null && temp.exists()) {
                            BrowserViewer.this.autoRefresh.setEnabled(true);
                            if (BrowserViewer.this.autoRefresh.getSelection()) {
                                BrowserViewer.this.fileChangedWatchService(temp);
                            }
                        } else {
                            BrowserViewer.this.autoRefresh.setSelection(false);
                            BrowserViewer.this.toggleAutoRefresh();
                            BrowserViewer.this.autoRefresh.setEnabled(false);
                        }
                    }
                }
            });
        }
        this.browser.addTitleListener(event -> {
            String oldTitle = this.title;
            this.title = event.title;
            this.firePropertyChangeEvent(PROPERTY_TITLE, oldTitle, this.title);
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
        try {
            int size = this.propertyListeners.size();
            PropertyChangeListener[] pcl = new PropertyChangeListener[size];
            this.propertyListeners.toArray(pcl);
            int i = 0;
            while (i < size) {
                try {
                    pcl[i].propertyChange(event);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public boolean forward() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.forward();
    }

    public boolean back() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.back();
    }

    public boolean isBackEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isBackEnabled();
    }

    public boolean isForwardEnabled() {
        if (this.browser == null) {
            return false;
        }
        return this.browser.isForwardEnabled();
    }

    public void stop() {
        if (this.browser != null) {
            this.browser.stop();
        }
    }

    private boolean navigate(String url) {
        Trace.trace(Trace.FINER, "Navigate: " + url);
        if (url != null && url.equals(this.getURL())) {
            this.refresh();
            return true;
        }
        if (this.browser != null) {
            return this.browser.setUrl(url, null, new String[]{"Cache-Control: no-cache"});
        }
        return this.text.setUrl(url);
    }

    public void refresh() {
        if (this.browser != null) {
            this.browser.refresh();
        } else {
            this.text.refresh();
        }
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {}
    }

    private void toggleAutoRefresh() {
        File temp = BrowserViewer.getFile(this.browser.getUrl());
        if (temp != null && temp.exists() && this.autoRefresh.getSelection()) {
            this.refresh();
            this.fileChangedWatchService(temp);
        } else if (this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setURL(String url, boolean browse) {
        Trace.trace(Trace.FINEST, "setURL: " + url + " " + browse);
        if (url == null) {
            this.home();
            return;
        }
        if ("eclipse".equalsIgnoreCase(url)) {
            url = "http://www.eclipse.org";
        } else if ("wtp".equalsIgnoreCase(url)) {
            url = "http://www.eclipse.org/webtools/";
        }
        if (browse) {
            this.navigate(url);
        }
        this.addToHistory(url);
        this.updateHistory();
    }

    protected void addToHistory(String url) {
        if (history == null) {
            history = WebBrowserPreference.getInternalWebBrowserHistory();
        }
        int found = -1;
        int size = history.size();
        int i = 0;
        while (i < size) {
            String s = history.get(i);
            if (s.equals(url)) {
                found = i;
                break;
            }
            ++i;
        }
        if (found == -1) {
            if (size >= 50) {
                history.remove(size - 1);
            }
            history.add(0, url);
            WebBrowserPreference.setInternalWebBrowserHistory(history);
        } else if (found != 0) {
            history.remove(found);
            history.add(0, url);
            WebBrowserPreference.setInternalWebBrowserHistory(history);
        }
    }

    public void dispose() {
        super.dispose();
        this.showToolbar = false;
        if (this.busy != null) {
            this.busy.dispose();
        }
        this.busy = null;
        this.browser = null;
        this.text = null;
        if (this.clipboard != null) {
            this.clipboard.dispose();
        }
        this.clipboard = null;
        this.removeSynchronizationListener();
    }

    private ToolBar createLocationBar(Composite parent) {
        this.combo = new Combo(parent, 4);
        this.updateHistory();
        this.combo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                if (this.combo.getSelectionIndex() != -1 && !this.combo.getListVisible()) {
                    this.setURL(this.combo.getItem(this.combo.getSelectionIndex()));
                }
            }
            catch (Exception exception) {}
        }));
        this.combo.addListener(14, e -> this.setURL(this.combo.getText()));
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        ToolItem go = new ToolItem(toolbar, 0);
        go.setImage(this.getImage(URL_ELCL, "nav_go.png"));
        go.setHotImage(this.getImage(URL_CLCL, "nav_go.png"));
        go.setDisabledImage(this.getImage(URL_DLCL, "nav_go.png"));
        go.setToolTipText(Messages.actionWebBrowserGo);
        go.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setURL(this.combo.getText())));
        return toolbar;
    }

    private ToolBar createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800000);
        this.back = new ToolItem(toolbar, 0);
        this.back.setImage(this.getImage(URL_ELCL, "nav_backward.png"));
        this.back.setHotImage(this.getImage(URL_CLCL, "nav_backward.png"));
        this.back.setDisabledImage(this.getImage(URL_DLCL, "nav_backward.png"));
        this.back.setToolTipText(Messages.actionWebBrowserBack);
        this.back.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.back();
        }));
        this.forward = new ToolItem(toolbar, 0);
        this.forward.setImage(this.getImage(URL_ELCL, "nav_forward.png"));
        this.forward.setHotImage(this.getImage(URL_CLCL, "nav_forward.png"));
        this.forward.setDisabledImage(this.getImage(URL_DLCL, "nav_forward.png"));
        this.forward.setToolTipText(Messages.actionWebBrowserForward);
        this.forward.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean bl = this.forward();
        }));
        ToolItem stop = new ToolItem(toolbar, 0);
        stop.setImage(this.getImage(URL_ELCL, "nav_stop.png"));
        stop.setHotImage(this.getImage(URL_CLCL, "nav_stop.png"));
        stop.setDisabledImage(this.getImage(URL_DLCL, "nav_stop.png"));
        stop.setToolTipText(Messages.actionWebBrowserStop);
        stop.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.stop()));
        ToolItem refresh = new ToolItem(toolbar, 4);
        refresh.setImage(this.getImage(URL_ELCL, "nav_refresh.png"));
        refresh.setHotImage(this.getImage(URL_CLCL, "nav_refresh.png"));
        refresh.setDisabledImage(this.getImage(URL_DLCL, "nav_refresh.png"));
        refresh.setToolTipText(Messages.actionWebBrowserRefresh);
        Menu refreshMenu = new Menu((Decorations)this.getShell(), 8);
        this.autoRefresh = new MenuItem(refreshMenu, 32);
        this.autoRefresh.setText(Messages.actionWebBrowserAutoRefresh);
        this.autoRefresh.setEnabled(false);
        refresh.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (e.detail == 4) {
                refreshMenu.setVisible(true);
            } else {
                this.refresh();
            }
        }));
        this.autoRefresh.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.toggleAutoRefresh()));
        return toolbar;
    }

    private Image getImage(String folder, String name) {
        ImageDescriptor id = ImageResourceManager.getImageDescriptor(String.valueOf(folder) + name);
        return this.imageManager.getImage(id);
    }

    public String getURL() {
        if (this.browser != null) {
            return this.browser.getUrl();
        }
        return this.text.getUrl();
    }

    public boolean setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
            this.updateHistory();
            return true;
        }
        return super.setFocus();
    }

    protected void updateHistory() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        String temp = this.combo.getText();
        if (history == null) {
            history = WebBrowserPreference.getInternalWebBrowserHistory();
        }
        String[] historyList = new String[history.size()];
        history.toArray(historyList);
        this.combo.setItems(historyList);
        this.combo.setText(temp);
    }

    public IBrowserViewerContainer getContainer() {
        return this.container;
    }

    public void setContainer(IBrowserViewerContainer container) {
        IStatusLineManager manager;
        if (container == null && this.container != null && (manager = this.container.getActionBars().getStatusLineManager()) != null) {
            manager.getProgressMonitor().done();
        }
        this.container = container;
    }

    protected void addSynchronizationListener() {
        if (this.fileListenerThread != null) {
            return;
        }
        this.fileListenerThread = new Thread("Browser file synchronization"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (BrowserViewer.this.fileListenerThread != null) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {}
                    Object object = BrowserViewer.this.syncObject;
                    synchronized (object) {
                        if (BrowserViewer.this.file != null && BrowserViewer.this.file.lastModified() != BrowserViewer.this.timestamp) {
                            BrowserViewer.this.timestamp = BrowserViewer.this.file.lastModified();
                            Display.getDefault().syncExec(() -> BrowserViewer.this.refresh());
                        }
                    }
                }
            }
        };
        this.fileListenerThread.setDaemon(true);
        this.fileListenerThread.setPriority(1);
        this.locationListener2 = new LocationAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(LocationEvent event) {
                File temp = BrowserViewer.getFile(event.location);
                if (temp != null && temp.exists()) {
                    Object object = BrowserViewer.this.syncObject;
                    synchronized (object) {
                        BrowserViewer.this.file = temp;
                        BrowserViewer.this.timestamp = BrowserViewer.this.file.lastModified();
                    }
                } else {
                    BrowserViewer.this.file = null;
                }
            }
        };
        this.browser.addLocationListener(this.locationListener2);
        File temp = BrowserViewer.getFile(this.browser.getUrl());
        if (temp != null && temp.exists()) {
            this.file = temp;
            this.timestamp = this.file.lastModified();
        }
        this.fileListenerThread.start();
    }

    protected static File getFile(String location) {
        if (location == null) {
            return null;
        }
        if (location.startsWith("file:/")) {
            location = location.substring(6);
        }
        return new File(location);
    }

    protected void removeSynchronizationListener() {
        if (this.fileListenerThread == null) {
            return;
        }
        this.fileListenerThread = null;
        this.browser.removeLocationListener(this.locationListener2);
        this.locationListener2 = null;
    }

    private void fileChangedWatchService(File file) {
        while (file.isFile()) {
            file = file.getParentFile();
        }
        try {
            if (this.watcher != null) {
                this.watcher.close();
            }
            this.watcher = FileSystems.getDefault().newWatchService();
            Path path = FileSystems.getDefault().getPath(file.getAbsolutePath(), new String[0]);
            path.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            new Thread(() -> {
                try {
                    WatchKey key = this.watcher.take();
                    while (key != null) {
                        for (WatchEvent<?> event : key.pollEvents()) {
                            Path changedPath = (Path)event.context();
                            Display.getDefault().asyncExec(() -> {
                                if (this.browser.getUrl().endsWith(changedPath.toString())) {
                                    this.browser.refresh();
                                }
                            });
                        }
                        key.reset();
                        key = this.watcher.take();
                    }
                }
                catch (InterruptedException | ClosedWatchServiceException exception) {}
            }).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface IBackNextListener {
        public void updateBackNextBusy();
    }

    public static interface ILocationListener {
        public void locationChanged(String var1);

        public void historyChanged(String[] var1);
    }
}

