/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal.old;

import org.eclipse.osee.framework.messaging.Message;
import org.eclipse.osee.framework.messaging.ReceiveListener;
import org.eclipse.osee.framework.messaging.SendListener;
import org.eclipse.osee.framework.messaging.id.MessageId;
import org.eclipse.osee.framework.messaging.internal.old.ConcurrentListMap;

public class MessageListenerCollection {
    private final ConcurrentListMap<MessageId, ReceiveListener> receiveListeners = new ConcurrentListMap();
    private final ConcurrentListMap<MessageId, SendListener> sendListeners = new ConcurrentListMap();

    public boolean addReceiveListener(MessageId messageId, ReceiveListener receiveListener) {
        return this.receiveListeners.add(messageId, receiveListener);
    }

    public boolean addSendListener(MessageId messageId, SendListener sendListener) {
        return this.sendListeners.add(messageId, sendListener);
    }

    public boolean removeReceiveListener(MessageId messageId, ReceiveListener receiveListener) {
        return this.receiveListeners.remove(messageId, receiveListener);
    }

    public boolean removeSendListener(MessageId messageId, SendListener sendListener) {
        return this.sendListeners.remove(messageId, sendListener);
    }

    public void notifyReceiveListeners(Message message) {
        for (ReceiveListener listener : this.receiveListeners.get(message.getId())) {
            listener.handle(message);
        }
    }

    public void dispose() {
        this.receiveListeners.clear();
        this.sendListeners.clear();
    }
}

