/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.graphics.Image;

public abstract class WorldSearchItem {
    private final String name;
    protected static final Set<Artifact> EMPTY_SET = new HashSet<Artifact>();
    protected boolean cancelled = false;
    private LoadView loadView;
    protected final AtsImage atsImage;

    public WorldSearchItem(String name, LoadView loadView, boolean cancelled, AtsImage atsImage) {
        this.name = name;
        this.loadView = loadView;
        this.cancelled = cancelled;
        this.atsImage = atsImage;
    }

    public WorldSearchItem(String name, LoadView loadView, AtsImage atsImage) {
        this(name, loadView, false, atsImage);
    }

    public WorldSearchItem(WorldSearchItem worldSearchItem, AtsImage atsImage) {
        this(worldSearchItem.name, worldSearchItem.loadView, worldSearchItem.cancelled, atsImage);
    }

    public abstract WorldSearchItem copy();

    public String getName() {
        return this.name;
    }

    public String getSelectedName(SearchType searchType) {
        return this.getName();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public LoadView getLoadView() {
        return this.loadView;
    }

    public void setLoadView(LoadView loadView) {
        this.loadView = loadView;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return ex.getLocalizedMessage();
        }
    }

    public Image getImage() {
        return this.atsImage == null ? null : ImageManager.getImage((OseeImage)this.atsImage);
    }

    public AtsImage getatsImage() {
        return this.atsImage;
    }

    public static enum LoadView {
        TaskEditor,
        WorldEditor,
        None;

    }

    public static enum SearchType {
        Search,
        ReSearch;

    }
}

