/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.XViewerTextFilter;
import org.eclipse.nebula.widgets.xviewer.action.ColumnMultiEditAction;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.customize.XViewerCustomMenu;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.actions.AddTaskAction;
import org.eclipse.osee.ats.ide.actions.DeletePurgeAtsArtifactsAction;
import org.eclipse.osee.ats.ide.actions.DeleteTasksAction;
import org.eclipse.osee.ats.ide.actions.EditActionableItemsAction;
import org.eclipse.osee.ats.ide.actions.EditAssigneeAction;
import org.eclipse.osee.ats.ide.actions.EditBlockedStatusAction;
import org.eclipse.osee.ats.ide.actions.EditHoldStatusAction;
import org.eclipse.osee.ats.ide.actions.EditStatusAction;
import org.eclipse.osee.ats.ide.actions.EmailActionAction;
import org.eclipse.osee.ats.ide.actions.FavoriteAction;
import org.eclipse.osee.ats.ide.actions.IAtsTaskArtifactProvider;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.actions.ISelectedTeamWorkflowArtifacts;
import org.eclipse.osee.ats.ide.actions.SubscribedAction;
import org.eclipse.osee.ats.ide.agile.SprintOrderColumn;
import org.eclipse.osee.ats.ide.column.GoalOrderColumn;
import org.eclipse.osee.ats.ide.column.IPersistAltLeftClickProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XWorldTextFilter;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsAttributeColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.action.ActionArtifactRollup;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionToMenu;
import org.eclipse.osee.ats.ide.world.IMenuActionProvider;
import org.eclipse.osee.ats.ide.world.WorldContentProvider;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.PresentationType;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ISelectedArtifacts;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.ArtifactDoubleClick;
import org.eclipse.osee.framework.ui.skynet.OpenContributionItem;
import org.eclipse.osee.framework.ui.skynet.artifact.ArtifactPromptChange;
import org.eclipse.osee.framework.ui.skynet.render.RendererManager;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.skynet.column.IAttributeColumn;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class WorldXViewer
extends XViewer
implements ISelectedAtsArtifacts,
IPersistAltLeftClickProvider,
ISelectedTeamWorkflowArtifacts,
ISelectedArtifacts,
IDirtiableEditor {
    private String extendedStatusString = "";
    public static final String MENU_GROUP_ATS_WORLD_EDIT = "ATS WORLD EDIT";
    public static final String MENU_GROUP_ATS_WORLD_OPEN = "ATS WORLD OPEN";
    public static final String MENU_GROUP_ATS_WORLD_OTHER = "ATS WORLD OTHER";
    public static final String ADD_AS_FAVORITE = "Add as Favorite";
    public static final String REMOVE_FAVORITE = "Remove Favorite";
    public static final String SUBSCRIBE = "Subscribe for Notifications";
    public static final String UN_SUBSCRIBE = "Un-Subscribe for Notifications";
    public final WorldXViewer thisXViewer = this;
    public List<IMenuActionProvider> menuActionProviders = new ArrayList<IMenuActionProvider>();
    protected final IDirtiableEditor editor;
    private GoalArtifact parentGoalArtifact;
    private SprintArtifact parentSprintArtifact;
    Action editActionableItemsAction;
    protected EditStatusAction editStatusAction;
    EditAssigneeAction editAssigneeAction;
    EditBlockedStatusAction editBlockedStatusAction;
    EditHoldStatusAction editHoldStatusAction;
    FavoriteAction favoritesAction;
    SubscribedAction subscribedAction;
    DeletePurgeAtsArtifactsAction deletePurgeAtsObjectAction;
    EmailActionAction emailAction;
    Action resetActionArtifactAction;
    DeleteTasksAction deleteTasksAction;
    AddTaskAction addTaskAction;
    private boolean showRemoveMenuItems = true;

    public WorldXViewer(Composite parent, int style, IXViewerFactory xViewerFactory, IDirtiableEditor editor) {
        super(parent, style, xViewerFactory);
        this.editor = editor;
        this.getTree().addKeyListener((KeyListener)new KeySelectedListener());
    }

    protected void createSupportWidgets(Composite parent) {
        super.createSupportWidgets(parent);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WorldXViewer.this.getContentProvider() instanceof WorldContentProvider) {
                    ((WorldContentProvider)WorldXViewer.this.getContentProvider()).clear(false);
                }
            }
        });
        this.createMenuActions();
    }

    public void createMenuActions() {
        this.favoritesAction = new FavoriteAction(this);
        this.subscribedAction = new SubscribedAction(this);
        this.deletePurgeAtsObjectAction = new DeletePurgeAtsArtifactsAction(this, false);
        this.emailAction = new EmailActionAction(this);
        this.editStatusAction = new EditStatusAction(this, this, this);
        this.editAssigneeAction = new EditAssigneeAction(this, this);
        this.editBlockedStatusAction = new EditBlockedStatusAction(this);
        this.editHoldStatusAction = new EditHoldStatusAction(this);
        this.addTaskAction = new AddTaskAction(this);
        IAtsTaskArtifactProvider taskProvider = new IAtsTaskArtifactProvider(){

            @Override
            public List<TaskArtifact> getSelectedArtifacts() {
                return WorldXViewer.this.getSelectedTaskArtifacts();
            }
        };
        this.deleteTasksAction = new DeleteTasksAction(taskProvider);
        new Action("Edit", 1){

            public void run() {
                try {
                    new ColumnMultiEditAction((XViewer)WorldXViewer.this.thisXViewer).run();
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        };
        this.editActionableItemsAction = new Action("Edit Actionable Item(s)", 1){

            public void run() {
                try {
                    if (WorldXViewer.this.getSelectedTeamWorkflowArtifacts().size() == 1) {
                        TeamWorkFlowArtifact teamArt = WorldXViewer.this.getSelectedTeamWorkflowArtifacts().iterator().next();
                        EditActionableItemsAction.editActionableItems(teamArt);
                        WorldXViewer.this.refresh(WorldXViewer.this.getSelectedArtifactItems().toArray()[0]);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        };
        this.resetActionArtifactAction = new Action("Reset Action off Children", 1){

            public void run() {
                try {
                    SkynetTransaction transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)"Reset Action off Children");
                    for (IAtsAction actionArt : WorldXViewer.this.getSelectedActions()) {
                        ActionArtifactRollup rollup = new ActionArtifactRollup(actionArt);
                        rollup.resetAttributesOffChildren();
                        ((Artifact)actionArt).persist(transaction);
                    }
                    transaction.execute();
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        };
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        super.handleColumnMultiEdit(treeColumn, treeItems);
        this.handleColumnMultiEdit(treeColumn, treeItems, true);
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems, boolean persist) {
        if (treeColumn.getData() instanceof IMultiColumnEditProvider) {
            return;
        }
        if (!(treeColumn.getData() instanceof IAttributeColumn) && !(treeColumn.getData() instanceof XViewerAtsAttributeColumn)) {
            AWorkbench.popup((String)"ERROR", (String)("Column is not attribute and thus not multi-editable " + treeColumn.getText()));
            return;
        }
        XResultData rData = new XResultData();
        AttributeTypeToken attributeType = null;
        if (treeColumn.getData() instanceof IAttributeColumn) {
            attributeType = ((IAttributeColumn)treeColumn.getData()).getAttributeType();
        }
        if (attributeType == null) {
            AWorkbench.popup((String)"ERROR", (String)("Can't retrieve attribute name from attribute column " + treeColumn.getText()));
            return;
        }
        HashSet<Artifact> useArts = new HashSet<Artifact>();
        for (TreeItem item : treeItems) {
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(item);
            try {
                if (art.isAttributeTypeValid((AttributeTypeId)attributeType)) {
                    useArts.add(art);
                    continue;
                }
                rData.error(attributeType + " not valid for artifact " + art.toStringWithId());
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                rData.error(ex.getLocalizedMessage());
            }
        }
        try {
            if (!rData.isEmpty()) {
                XResultDataUI.report((XResultData)rData, (String)"Column Multi Edit Errors");
                return;
            }
            if (useArts.size() > 0) {
                ArtifactPromptChange.promptChangeAttribute((AttributeTypeToken)attributeType, useArts, (boolean)persist);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public boolean isColumnMultiEditable(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (!(treeColumn.getData() instanceof XViewerColumn)) {
            return false;
        }
        if (!((XViewerColumn)treeColumn.getData()).isMultiColumnEditable()) {
            return false;
        }
        if ((XViewerColumn)treeColumn.getData() instanceof IMultiColumnEditProvider) {
            return true;
        }
        AttributeTypeToken attributeType = null;
        if (!(treeColumn.getData() instanceof IAttributeColumn)) {
            return false;
        }
        attributeType = ((IAttributeColumn)treeColumn.getData()).getAttributeType();
        if (attributeType == null) {
            AWorkbench.popup((String)"ERROR", (String)("Can't retrieve attribute name from attribute column " + treeColumn.getText()));
            return false;
        }
        for (TreeItem item : treeItems) {
            if (Artifacts.isOfType((Object)item.getData(), (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                return false;
            }
            try {
                Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact(item);
                if (artifact.isAttributeTypeValid((AttributeTypeId)attributeType)) continue;
                return false;
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    public boolean isColumnMultiEditEnabled() {
        return true;
    }

    public MenuManager updateEditMenu(MenuManager mm) {
        List<TreeItem> selectedTreeItems = Arrays.asList(this.thisXViewer.getTree().getSelection());
        Set editableColumns = ColumnMultiEditAction.getEditableTreeColumns((XViewer)this.thisXViewer, selectedTreeItems);
        return XViewerCustomMenu.createEditMenuManager((XViewer)this.thisXViewer, (String)"Edit", selectedTreeItems, (Set)editableColumns);
    }

    public void updateEditMenuActions() {
        MenuManager mm = this.getMenuManager();
        MenuManager editMenuManager = this.updateEditMenu(mm);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)editMenuManager);
        Set<Artifact> workflowArtifacts = this.getSelectedWorkflowArtifacts();
        if (!workflowArtifacts.isEmpty()) {
            mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)TransitionToMenu.createTransitionToMenuManager(this.thisXViewer, "Transition-To", workflowArtifacts));
        }
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editStatusAction);
        this.editStatusAction.setEnabled(this.getSelectedWorkflowArtifacts().size() > 0);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editAssigneeAction);
        this.editAssigneeAction.setEnabled(this.getSelectedWorkflowArtifacts().size() > 0);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editActionableItemsAction);
        this.editActionableItemsAction.setEnabled(this.getSelectedTeamWorkflowArtifacts().size() == 1);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editBlockedStatusAction);
        this.editBlockedStatusAction.setEnabled(this.getSelectedWorkflowArtifacts().size() >= 1);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editHoldStatusAction);
        this.editHoldStatusAction.setEnabled(this.getSelectedWorkflowArtifacts().size() >= 1);
    }

    public void updateMenuActionsForTable() {
        MenuManager mm = this.getMenuManager();
        OpenContributionItem contrib = new OpenContributionItem(String.valueOf(this.getClass().getSimpleName()) + ".open", (ISelectedArtifacts)this);
        contrib.fill(mm.getMenu(), -1);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)contrib);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new GroupMarker(MENU_GROUP_ATS_WORLD_EDIT));
        this.updateEditMenuActions();
        if (AtsApiService.get().getUserService().isAtsAdmin()) {
            mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
            mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.deletePurgeAtsObjectAction);
            this.deletePurgeAtsObjectAction.setEnabled(this.getSelectedAtsArtifacts().size() > 0);
        }
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        if (this.showTaskMenu()) {
            mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.addTaskAction);
            this.addTaskAction.updateEnablement(this.isAddTaskEnabled());
            mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.deleteTasksAction);
            this.deleteTasksAction.updateEnablement(this.getSelectedArtifacts());
        }
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new GroupMarker(MENU_GROUP_ATS_WORLD_OPEN));
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.favoritesAction);
        this.favoritesAction.updateEnablement();
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.subscribedAction);
        this.subscribedAction.updateEnablement();
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.emailAction);
        this.emailAction.setEnabled(this.getSelectedWorkflowArtifacts().size() == 1);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.resetActionArtifactAction);
        this.resetActionArtifactAction.setEnabled(this.getSelectedActions().size() > 0);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new GroupMarker(MENU_GROUP_ATS_WORLD_OTHER));
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        for (IMenuActionProvider provider : this.menuActionProviders) {
            provider.updateMenuActionsForTable();
        }
    }

    protected boolean showTaskMenu() {
        return true;
    }

    protected boolean isAddTaskEnabled() {
        return true;
    }

    public void handleDoubleClick() {
        ArtifactDoubleClick.openArtifact((ISelection)this.getSelection());
    }

    public List<Artifact> getLoadedArtifacts() {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        if (this.getRoot() != null) {
            for (Object artifact : (Collection)this.getRoot()) {
                if (!(artifact instanceof Artifact)) continue;
                arts.add(AtsApiService.get().getQueryServiceIde().getArtifact(artifact));
            }
        }
        return arts;
    }

    public void clear(boolean forcePend) {
        ((WorldContentProvider)this.getContentProvider()).clear(forcePend);
    }

    public void insert(Artifact toInsert, int position) {
        this.insert(this.getRoot(), toInsert, position);
    }

    public void dispose() {
        this.getLabelProvider().dispose();
        super.dispose();
    }

    public List<Artifact> getSelectedArtifacts() {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Artifact artifact;
                TreeItem item = treeItemArray[n2];
                if (item.getData() instanceof IAtsWorkItem && (artifact = AtsApiService.get().getQueryServiceIde().getArtifact(item)) != null) {
                    arts.add(artifact);
                }
                ++n2;
            }
        }
        return arts;
    }

    @Override
    public List<TaskArtifact> getSelectedTaskArtifacts() {
        ArrayList<TaskArtifact> arts = new ArrayList<TaskArtifact>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (Artifacts.isOfType((Object)item.getData(), (ArtifactTypeToken)AtsArtifactTypes.Task)) {
                    arts.add((TaskArtifact)((Object)item.getData()));
                }
                ++n2;
            }
        }
        return arts;
    }

    @Override
    public Collection<TeamWorkFlowArtifact> getSelectedTeamWorkflowArtifacts() {
        HashSet<TeamWorkFlowArtifact> teamArts = new HashSet<TeamWorkFlowArtifact>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (Artifacts.isOfType((Object)item.getData(), (ArtifactTypeToken)AtsArtifactTypes.TeamWorkflow)) {
                    teamArts.add((TeamWorkFlowArtifact)((Object)item.getData()));
                }
                if (Artifacts.isOfType((Object)item.getData(), (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                    try {
                        if (AtsApiService.get().getWorkItemService().getTeams(item.getData()).size() == 1) {
                            teamArts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getWorkItemService().getTeams(item.getData()))));
                        }
                    }
                    catch (OseeCoreException oseeCoreException) {}
                }
                ++n2;
            }
        }
        return teamArts;
    }

    @Override
    public Set<Artifact> getSelectedWorkflowArtifacts() {
        HashSet<Artifact> smaArts = new HashSet<Artifact>();
        try {
            for (Object obj : (IStructuredSelection)this.getSelection()) {
                if (obj instanceof AbstractWorkflowArtifact) {
                    smaArts.add((AbstractWorkflowArtifact)((Object)obj));
                    continue;
                }
                if (!Artifacts.isOfType(obj, (ArtifactTypeToken)AtsArtifactTypes.Action)) continue;
                smaArts.addAll(Collections.castAll((Collection)AtsObjects.getArtifacts((Collection)AtsApiService.get().getWorkItemService().getTeams(obj))));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return smaArts;
    }

    public Set<IAtsAction> getSelectedActions() {
        HashSet<IAtsAction> actionArts = new HashSet<IAtsAction>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                if (Artifacts.isOfType((Object)item.getData(), (ArtifactTypeToken)AtsArtifactTypes.Action)) {
                    actionArts.add((IAtsAction)item.getData());
                }
                ++n2;
            }
        }
        return actionArts;
    }

    public List<Artifact> getSelectedArtifactItems() {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                arts.add(AtsApiService.get().getQueryServiceIde().getArtifact(item));
                ++n2;
            }
        }
        return arts;
    }

    public String getStatusString() {
        return this.extendedStatusString;
    }

    public void setExtendedStatusString(String extendedStatusString) {
        this.extendedStatusString = extendedStatusString;
        this.updateStatusLabel();
    }

    protected void doUpdateItem(Item item, Object element) {
        if (item instanceof TreeItem) {
            SprintArtifact parentSprintArtifact1;
            GoalArtifact parentGoalArtifact = GoalOrderColumn.getParentGoalArtifact((TreeItem)item, AtsArtifactTypes.Goal);
            if (parentGoalArtifact != null) {
                this.parentGoalArtifact = parentGoalArtifact;
            }
            if ((parentSprintArtifact1 = SprintOrderColumn.getParentSprintArtifact((TreeItem)item)) != null) {
                this.parentSprintArtifact = parentSprintArtifact1;
            }
        }
        super.doUpdateItem(item, element);
    }

    public void addMenuActionProvider(IMenuActionProvider provider) {
        this.menuActionProviders.add(provider);
    }

    @Override
    public List<Artifact> getSelectedAtsArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Object obj : (IStructuredSelection)this.getSelection()) {
            if (!(obj instanceof AbstractWorkflowArtifact)) continue;
            artifacts.add((AbstractWorkflowArtifact)((Object)obj));
        }
        return artifacts;
    }

    @Override
    public boolean isAltLeftClickPersist() {
        return true;
    }

    public void onDirtied() {
        if (this.editor != null) {
            this.editor.onDirtied();
        }
    }

    public void setParentGoal(GoalArtifact parentGoalArtifact) {
        this.parentGoalArtifact = parentGoalArtifact;
    }

    public GoalArtifact getParentGoalArtifact() {
        return this.parentGoalArtifact;
    }

    public void setParentSprint(SprintArtifact parentSprintArtifact) {
        this.parentSprintArtifact = parentSprintArtifact;
    }

    public SprintArtifact getParentSprintArtifact() {
        return this.parentSprintArtifact;
    }

    public boolean isDisposed() {
        return this.getTree() == null || this.getTree().isDisposed();
    }

    public XViewerTextFilter getXViewerTextFilter() {
        return new XWorldTextFilter(this);
    }

    public void refresh() {
        if (this.isDisposed()) {
            return;
        }
        super.refreshColumnsWithPreCompute(this.getInput());
    }

    public void setShowRemoveMenuItems(boolean showRemoveMenuItems) {
        this.showRemoveMenuItems = showRemoveMenuItems;
    }

    public boolean isRemoveItemsMenuOptionEnabled() {
        return this.showRemoveMenuItems;
    }

    private class KeySelectedListener
    implements KeyListener {
        private KeySelectedListener() {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.keyCode == 0x100000E) {
                try {
                    Collection artifacts = WorldXViewer.this.getSelectedArtifacts();
                    RendererManager.open((Collection)artifacts, (PresentationType)PresentationType.F5_DIFF);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        }
    }
}

