/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.validate;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.validation.OseeValidator;

public class ArtifactValidationRule
extends AbstractValidationRule {
    public ArtifactValidationRule(AtsApi atsApi) {
        super(atsApi);
    }

    public void validate(ArtifactToken artToken, XResultData results) {
        Artifact artifact = AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)artToken);
        Conditions.assertNotNull((Object)artifact, (String)"artifact not found for %s", (Object[])new Object[]{artToken.toStringWithId()});
        IStatus status = OseeValidator.getInstance().validate(100, artifact);
        if (!status.isOK()) {
            this.logError((ArtifactToken)artifact, status.getMessage(), results);
        }
    }

    public String getRuleDescription() {
        return "All Errors reported must be fixed.";
    }

    public String getRuleTitle() {
        return "Artifact Validation Checks:";
    }
}

