/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client;

import java.net.InetAddress;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.ICredentialProvider;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.core.client.server.HttpServer;
import org.eclipse.osee.framework.core.data.OseeCodeVersion;
import org.eclipse.osee.framework.core.data.OseeCredential;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public abstract class BaseCredentialProvider
implements ICredentialProvider {
    @Override
    public OseeCredential getCredential() {
        OseeCredential credential = new OseeCredential();
        credential.setUserName("");
        credential.setPassword("");
        String localAddress = HttpServer.getServerAddressForExternalCommunication();
        credential.setClientAddress(Strings.isValid((String)localAddress) ? localAddress : "Unknown");
        credential.setClientPort(String.valueOf(HttpServer.getDefaultServicePort()));
        credential.setClientVersion(OseeCodeVersion.getVersion());
        try {
            credential.setClientAddress(InetAddress.getLocalHost().getHostName());
        }
        catch (Exception ex) {
            credential.setClientAddress("Unknown");
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        return credential;
    }
}

