/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.verification;

import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.internal.verification.api.VerificationData;
import org.mockito.verification.VerificationMode;

public abstract class VerificationWrapper<WrapperType extends VerificationMode>
implements VerificationMode {
    protected final WrapperType wrappedVerification;

    public VerificationWrapper(WrapperType wrappedVerification) {
        this.wrappedVerification = wrappedVerification;
    }

    @Override
    public void verify(VerificationData data) {
        this.wrappedVerification.verify(data);
    }

    protected abstract VerificationMode copySelfWithNewVerificationMode(VerificationMode var1);

    public VerificationMode times(int wantedNumberOfInvocations) {
        return this.copySelfWithNewVerificationMode(VerificationModeFactory.times(wantedNumberOfInvocations));
    }

    public VerificationMode never() {
        return this.copySelfWithNewVerificationMode(VerificationModeFactory.atMost(0));
    }

    public VerificationMode atLeastOnce() {
        return this.copySelfWithNewVerificationMode(VerificationModeFactory.atLeastOnce());
    }

    public VerificationMode atLeast(int minNumberOfInvocations) {
        return this.copySelfWithNewVerificationMode(VerificationModeFactory.atLeast(minNumberOfInvocations));
    }

    public VerificationMode atMost(int maxNumberOfInvocations) {
        return this.copySelfWithNewVerificationMode(VerificationModeFactory.atMost(maxNumberOfInvocations));
    }

    public VerificationMode only() {
        return this.copySelfWithNewVerificationMode(VerificationModeFactory.only());
    }
}

