/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server.task;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.plugin.core.server.task.TaskServerThread;

public class NativeTaskMaster {
    private boolean listening = true;
    private ServerSocket serverSocket;

    public static void main(String[] args) {
        if (args.length != 1) {
            XConsoleLogger.err((String)"Usage: java NativeTaskMaster <port>", (Object[])new Object[0]);
            return;
        }
        try {
            NativeTaskMaster app = new NativeTaskMaster(Integer.parseInt(args[0]));
            app.listen();
        }
        catch (NumberFormatException ex) {
            XConsoleLogger.err((Exception)ex);
            return;
        }
    }

    public NativeTaskMaster(int port) {
        if (port < 1) {
            throw new IllegalArgumentException("port argument must be a natural number");
        }
        try {
            this.serverSocket = new ServerSocket(port);
        }
        catch (IOException iOException) {
            XConsoleLogger.err((String)("Could not listen on port: " + port + "."), (Object[])new Object[0]);
            return;
        }
    }

    private void listen() {
        try {
            while (this.listening) {
                Socket socket = this.serverSocket.accept();
                new Thread(new TaskServerThread(587289473, socket)).start();
            }
            this.serverSocket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

