/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.core.internal.IRepositoryCommit;
import org.eclipse.egit.core.op.TagOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.JobFamilies;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.egit.ui.internal.dialogs.CreateTagDialog;
import org.eclipse.egit.ui.internal.push.PushTagsWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TagBuilder;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.widgets.Shell;

public class TagActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        RevCommit tagTarget;
        CreateTagDialog dialog;
        Repository repo;
        IRepositoryCommit commit = this.getCommit(TagActionHandler.getSelection(event));
        if (commit == null) {
            String currentBranchName;
            repo = this.getRepository(true, event);
            if (repo == null) {
                return null;
            }
            if (!repo.getRepositoryState().canCheckout()) {
                MessageDialog.openError((Shell)this.getShell(event), (String)UIText.TagAction_cannotCheckout, (String)MessageFormat.format(UIText.TagAction_repositoryState, repo.getRepositoryState().getDescription()));
                return null;
            }
            try {
                currentBranchName = repo.getBranch();
            }
            catch (IOException e) {
                Activator.handleError(UIText.TagAction_cannotGetBranchName, e, true);
                return null;
            }
            dialog = new CreateTagDialog(this.getShell(event), currentBranchName, repo);
        } else {
            repo = commit.getRepository();
            dialog = new CreateTagDialog(this.getShell(event), commit.getRevCommit().getId(), repo);
        }
        if (dialog.open() != 0) {
            return null;
        }
        final TagBuilder tag = new TagBuilder();
        PersonIdent personIdent = new PersonIdent(repo);
        final String tagName = dialog.getTagName();
        tag.setTag(tagName);
        tag.setTagger(personIdent);
        tag.setMessage(dialog.getTagMessage());
        if (commit == null) {
            try {
                tagTarget = this.getTagTarget(repo, dialog.getTagCommit());
            }
            catch (IOException e1) {
                Activator.handleError(UIText.TagAction_unableToResolveHeadObjectId, e1, true);
                return null;
            }
        } else {
            tagTarget = commit.getRevCommit();
        }
        tag.setObjectId((RevObject)tagTarget);
        String tagJobName = MessageFormat.format(UIText.TagAction_creating, tagName);
        final boolean shouldMoveTag = dialog.shouldOverWriteTag();
        final boolean isAnnotated = dialog.isAnnotated();
        Job tagJob = new Job(tagJobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        new TagOperation(repo, tag, shouldMoveTag, isAnnotated).execute(monitor);
                    }
                    catch (CoreException e) {
                        IStatus iStatus = Activator.createErrorStatus(UIText.TagAction_taggingFailed, e);
                        GitLightweightDecorator.refresh();
                        return iStatus;
                    }
                }
                finally {
                    GitLightweightDecorator.refresh();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return JobFamilies.TAG.equals(family) || super.belongsTo(family);
            }
        };
        if (dialog.shouldStartPushWizard()) {
            tagJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent jobChangeEvent) {
                    if (jobChangeEvent.getResult().isOK()) {
                        PushTagsWizard.openWizardDialog(repo, tagName);
                    }
                }
            });
        }
        tagJob.setUser(true);
        tagJob.schedule();
        return null;
    }

    private RevObject getTagTarget(Repository repo, ObjectId objectId) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (RevWalk rw = new RevWalk(repo);){
            if (objectId == null) {
                return rw.parseAny((AnyObjectId)repo.resolve("HEAD"));
            }
            return rw.parseAny((AnyObjectId)objectId);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private IRepositoryCommit getCommit(IStructuredSelection selection) {
        if (selection != null && selection.size() == 1) {
            Object obj = selection.getFirstElement();
            return (IRepositoryCommit)Adapters.adapt((Object)obj, IRepositoryCommit.class);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

