/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;

public class ConvertOseeTypesToLong {
    static Pattern oseeUuidPattern = Pattern.compile("uuid +(0x.*)");

    public static void main(String[] args) {
        try {
            XResultData results = new XResultData();
            for (String dirNam : Arrays.asList("C:\\UserData\\git_fix\\org.eclipse.osee\\plugins\\org.eclipse.osee.ats.api\\")) {
                File dir1 = new File(dirNam);
                for (String filename : Lib.readListFromDir((File)dir1, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                    if (!Strings.isValid((String)filename)) continue;
                    XConsoleLogger.err((String)String.format("Processing [%s]", filename), (Object[])new Object[0]);
                    File file = new File(dir1 + "\\" + filename);
                    try {
                        ConvertOseeTypesToLong.recurseAndFind(file, results);
                    }
                    catch (Exception ex) {
                        XConsoleLogger.err((String)ex.getLocalizedMessage(), (Object[])new Object[0]);
                    }
                }
            }
            String outputFilename = "C:\\UserData\\ConvertOseeTypesToLong.txt";
            Lib.writeStringToFile((String)results.toString(), (File)new File(outputFilename));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    private static void recurseAndFind(File file, XResultData results) throws IOException {
        String text;
        try {
            if (file.isDirectory()) {
                for (String filename : Lib.readListFromDir((File)file, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                    File childFile = new File(String.valueOf(file.getAbsolutePath()) + "\\" + filename);
                    try {
                        ConvertOseeTypesToLong.recurseAndFind(childFile, results);
                    }
                    catch (Exception ex) {
                        XConsoleLogger.err((String)ex.getLocalizedMessage(), (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            XConsoleLogger.err((String)ex.getLocalizedMessage(), (Object[])new Object[0]);
        }
        if (file.getAbsolutePath().endsWith(".java")) {
            text = Lib.fileToString((File)file);
            for (String createTypePrefix : Arrays.asList("createType\\(", "AttributeTypeToken.valueOf\\(", "ArtifactTypeToken.valueOf\\(", "RelationTypeSide.create\\(RelationSide.SIDE_A, ")) {
                Pattern javaTypePattern = Pattern.compile(String.valueOf(createTypePrefix) + "(.*)L,");
                Matcher matcher = javaTypePattern.matcher(text);
                Map<String, Long> hexToLong = ConvertOseeTypesToLong.getHextToLong(matcher);
                if (!hexToLong.isEmpty()) {
                    for (Map.Entry<String, Long> entry : hexToLong.entrySet()) {
                        String hex = entry.getKey();
                        Long id = entry.getValue();
                        text = id > Integer.MAX_VALUE ? text.replaceAll(String.valueOf(createTypePrefix) + hex + "L,", String.valueOf(createTypePrefix) + id + "L,") : text.replaceAll(String.valueOf(createTypePrefix) + hex + "L,", String.valueOf(createTypePrefix) + id + ",");
                    }
                }
                Lib.writeStringToFile((String)text, (File)file);
            }
        } else if (file.getAbsolutePath().endsWith(".osee")) {
            XConsoleLogger.err((String)("File " + file.getName()), (Object[])new Object[0]);
            results.log("Converting osee types file " + file);
            text = Lib.fileToString((File)file);
            Matcher matcher = oseeUuidPattern.matcher(text);
            Map<String, Long> hexToLong = ConvertOseeTypesToLong.getHextToLong(matcher);
            text = text.replaceAll("uuid  0x", "uuid 0x");
            for (Map.Entry<String, Long> entry : hexToLong.entrySet()) {
                text = text.replaceAll("uuid " + entry.getKey(), "id " + entry.getValue().toString());
            }
            Lib.writeStringToFile((String)text, (File)file);
        }
    }

    private static Map<String, Long> getHextToLong(Matcher matcher) {
        HashMap<String, Long> hexToLong = new HashMap<String, Long>();
        while (matcher.find()) {
            String hex = matcher.group(1);
            if (!hex.startsWith("0x")) continue;
            String hexStr = hex.replaceFirst("0x", "");
            hexStr = hexStr.replaceFirst("L", "");
            hexStr = hexStr.replaceAll(" ", "");
            long longVal = Long.parseUnsignedLong(hexStr, 16);
            XConsoleLogger.err((String)(String.valueOf(hex) + "," + longVal), (Object[])new Object[0]);
            hexToLong.put(hex, longVal);
        }
        return hexToLong;
    }
}

