/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.TxCurrent;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;

public abstract class BaseTransactionData {
    private static final String GAMMA_ID_SEQ = "SKYNET_GAMMA_ID_SEQ";
    private static final String INSERT_INTO_TRANSACTION_TABLE = "INSERT INTO osee_txs (transaction_id, gamma_id, mod_type, tx_current, branch_id, app_id) VALUES (?, ?, ?, ?, ?, ?)";
    private final Id itemId;
    private ModificationType modificationType;
    private GammaId gammaId;
    private ApplicabilityId applicabilityId;

    public BaseTransactionData(Id itemId, ModificationType modificationType) {
        this.modificationType = modificationType;
        this.itemId = itemId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BaseTransactionData) {
            return this.itemId.equals(((BaseTransactionData)obj).itemId);
        }
        return false;
    }

    public int hashCode() {
        return this.itemId.hashCode();
    }

    protected void addInsertToBatch(InsertDataCollector collector) {
        ModificationType modTypeToStore = this.getAdjustedModificationType();
        this.internalAddInsertToBatch(collector, Integer.MAX_VALUE, INSERT_INTO_TRANSACTION_TABLE, collector.getTransaction(), this.getGammaId(), modTypeToStore, TxCurrent.getCurrent((ModificationType)modTypeToStore), collector.getBranch(), this.getApplicId());
    }

    private ModificationType getAdjustedModificationType() {
        ModificationType modtypeToReturn = this.getModificationType();
        if (modtypeToReturn == ModificationType.REPLACED_WITH_VERSION) {
            modtypeToReturn = ModificationType.MODIFIED;
        }
        return modtypeToReturn;
    }

    protected final Id getItemId() {
        return this.itemId;
    }

    protected final ModificationType getModificationType() {
        return this.modificationType;
    }

    protected final ApplicabilityId getApplicId() {
        if (this.applicabilityId == null) {
            this.applicabilityId = this.getApplicabilityId();
        }
        return this.applicabilityId;
    }

    protected final GammaId getGammaId() {
        if (this.gammaId == null) {
            this.gammaId = this.createGammaId();
        }
        return this.gammaId;
    }

    final void setModificationType(ModificationType modificationType) {
        this.modificationType = modificationType;
    }

    protected abstract OseeSql getSelectTxNotCurrentSql();

    protected final void internalAddInsertToBatch(InsertDataCollector collector, int insertPriority, String insertSql, Object ... data) {
        collector.internalAddInsertToBatch(insertPriority, insertSql, data);
    }

    protected abstract void internalUpdate(TransactionRecord var1);

    protected abstract void internalClearDirtyState();

    protected abstract void internalOnRollBack();

    protected abstract GammaId createGammaId();

    protected abstract ApplicabilityId getApplicabilityId();

    protected abstract void internalAddToEvents(ArtifactEvent var1);

    protected GammaId getNextGammaIdFromSequence() {
        return GammaId.valueOf((Long)ConnectionHandler.getNextSequence(GAMMA_ID_SEQ, true));
    }

    public static interface InsertDataCollector {
        public TransactionId getTransaction();

        public BranchId getBranch();

        public void internalAddInsertToBatch(int var1, String var2, Object ... var3);
    }
}

