/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.order.ArtifactRelationOrderAccessor;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderFactory;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderMerger;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderParser;

public class RelationOrderMergeUtility {
    public static RelationOrderData mergeRelationOrder(Artifact left, Artifact right) {
        RelationOrderFactory factory = new RelationOrderFactory();
        RelationOrderData leftData = factory.createRelationOrderData(left);
        RelationOrderData rightData = factory.createRelationOrderData(right);
        RelationOrderData mergedData = new RelationOrderData(new ArtifactRelationOrderAccessor(new RelationOrderParser()), right);
        for (Pair<RelationTypeToken, RelationSide> typeSide : RelationOrderMergeUtility.getAllTypeSides(leftData, rightData)) {
            RelationTypeToken type = (RelationTypeToken)typeSide.getFirst();
            RelationSide side = (RelationSide)typeSide.getSecond();
            RelationTypeSide rts = new RelationTypeSide(type, side);
            RelationSorter leftSorter = leftData.getCurrentSorterGuid(type, side);
            RelationSorter rightSorter = rightData.getCurrentSorterGuid(type, side);
            List<String> order = null;
            if (rightSorter.equals((Object)RelationSorter.USER_DEFINED) && leftSorter.equals((Object)RelationSorter.USER_DEFINED)) {
                order = RelationOrderMergeUtility.mergeTypeSideOrder(left, right, rts);
            }
            if (order == null) {
                return null;
            }
            mergedData.addOrderList(type, side, leftSorter, order);
        }
        return mergedData;
    }

    private static Collection<Pair<RelationTypeToken, RelationSide>> getAllTypeSides(RelationOrderData leftData, RelationOrderData rightData) {
        HashSet<Pair<RelationTypeToken, RelationSide>> rts = new HashSet<Pair<RelationTypeToken, RelationSide>>();
        rts.addAll(leftData.getAvailableTypeSides());
        rts.addAll(rightData.getAvailableTypeSides());
        return rts;
    }

    private static List<String> mergeTypeSideOrder(Artifact left, Artifact right, RelationTypeSide rts) {
        RelationOrderMerger<String> merger = new RelationOrderMerger<String>();
        List<String> leftRelatives = RelationOrderMergeUtility.getGuidList(left.getRelatedArtifacts(rts, DeletionFlag.EXCLUDE_DELETED));
        List<String> rightRelatives = RelationOrderMergeUtility.getGuidList(right.getRelatedArtifacts(rts, DeletionFlag.EXCLUDE_DELETED));
        Collection<String> mergedSet = RelationOrderMergeUtility.getMergedSet(left, right, rts);
        return merger.computeMergedOrder(leftRelatives, rightRelatives, mergedSet);
    }

    private static Collection<String> getMergedSet(Artifact left, Artifact right, RelationTypeSide relationTypeSide) {
        HashSet<String> mergedSet = new HashSet<String>();
        HashSet<String> deleted = new HashSet<String>();
        List<String> leftRelatives = RelationOrderMergeUtility.getGuidList(left.getRelatedArtifacts(relationTypeSide, DeletionFlag.EXCLUDE_DELETED));
        List<String> rightRelatives = RelationOrderMergeUtility.getGuidList(right.getRelatedArtifacts(relationTypeSide, DeletionFlag.EXCLUDE_DELETED));
        deleted.addAll(RelationOrderMergeUtility.getDeleted(left, relationTypeSide));
        deleted.addAll(RelationOrderMergeUtility.getDeleted(right, relationTypeSide));
        mergedSet.addAll(leftRelatives);
        mergedSet.addAll(rightRelatives);
        mergedSet.removeAll(deleted);
        return mergedSet;
    }

    private static List<String> getGuidList(List<Artifact> artifacts) {
        ArrayList<String> toReturn = new ArrayList<String>();
        for (Artifact art : artifacts) {
            toReturn.add(art.getGuid());
        }
        return toReturn;
    }

    private static Collection<String> getDeleted(Artifact art, RelationTypeSide relationType) {
        HashSet<String> toReturn = new HashSet<String>();
        for (RelationLink link : art.getRelationsAll(DeletionFlag.INCLUDE_DELETED)) {
            if (!link.isOfType((RelationTypeToken)relationType) || !link.isDeleted() || !link.getOppositeSide((ArtifactId)art).equals((Object)relationType.getSide())) continue;
            toReturn.add(link.getArtifactOnOtherSide((ArtifactId)art).getGuid());
        }
        for (Artifact relative : art.getRelatedArtifacts(relationType, DeletionFlag.INCLUDE_DELETED)) {
            if (!relative.isDeleted()) continue;
            toReturn.add(relative.getGuid());
        }
        return toReturn;
    }
}

