/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation;

import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.relation.RelationTypeSideSorter;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderData;
import org.eclipse.osee.framework.skynet.core.relation.order.RelationOrderFactory;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;

public class RelationLink
implements HasBranchId,
IRelationLink {
    private RelationId relationId;
    private GammaId gammaId;
    private String rationale;
    private final RelationTypeToken relationType;
    private boolean dirty;
    private final ArtifactToken artifactA;
    private final ArtifactToken artifactB;
    private final BranchId branch;
    private ModificationType modificationType;
    private final ApplicabilityId applicabilityId;
    private static final boolean SET_DIRTY = true;
    private static final boolean SET_NOT_DIRTY = false;
    private boolean useBackingData;

    public RelationLink(ArtifactToken artifactA, ArtifactToken artifactB, BranchId branch, RelationTypeToken relationType, RelationId relationId, GammaId gammaId, String rationale, ModificationType modificationType, ApplicabilityId applicabilityId) {
        this.relationType = relationType;
        this.relationId = relationId;
        this.gammaId = gammaId;
        this.rationale = rationale == null ? "" : rationale;
        this.dirty = false;
        this.artifactA = artifactA;
        this.artifactB = artifactB;
        this.branch = branch;
        this.applicabilityId = applicabilityId;
        this.internalSetModType(modificationType, false, false);
    }

    public void internalSetModType(ModificationType modificationType, boolean useBackingData, boolean dirty) {
        this.modificationType = modificationType;
        this.useBackingData = useBackingData;
        this.dirty = dirty;
    }

    public RelationSide getSide(ArtifactId artifact) {
        if (this.artifactA.equals(artifact)) {
            return RelationSide.SIDE_A;
        }
        if (this.artifactB.equals(artifact)) {
            return RelationSide.SIDE_B;
        }
        throw new IllegalArgumentException("The artifact " + artifact + " is on neither side of " + this);
    }

    public RelationSide getOppositeSide(ArtifactId artifact) {
        return this.getSide(artifact).oppositeSide();
    }

    public void replaceWithVersion(GammaId gammaId) {
        this.internalSetPersistenceData(gammaId, ModificationType.REPLACED_WITH_VERSION);
    }

    private void internalSetPersistenceData(GammaId gammaId, ModificationType modType) {
        this.internalSetModType(modType, true, true);
        this.internalSetGammaId(gammaId);
    }

    public ArtifactToken getArtifactId(RelationSide relationSide) {
        return relationSide == RelationSide.SIDE_A ? this.artifactA : this.artifactB;
    }

    public boolean isDeleted() {
        return this.modificationType.isDeleted();
    }

    public boolean isUnDeleted() {
        return this.modificationType.isUnDeleted();
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public ApplicabilityId getApplicabilityId() {
        return this.applicabilityId;
    }

    public void delete(boolean reorderRelations) {
        this.delete(reorderRelations, null);
    }

    public void delete(boolean reorderRelations, SkynetTransaction transaction) {
        this.internalDelete(reorderRelations, true);
        this.deleteEmptyRelationOrder(transaction);
    }

    private void deleteEmptyRelationOrder(SkynetTransaction transaction) {
        try {
            RelationOrderData relationOrderData;
            Artifact aArtifact = this.getArtifactA();
            if (aArtifact.getAttributeCount((AttributeTypeId)CoreAttributeTypes.RelationOrder) == 1 && !(relationOrderData = new RelationOrderFactory().createRelationOrderData(aArtifact)).hasEntries()) {
                aArtifact.getSoleAttribute((AttributeTypeId)CoreAttributeTypes.RelationOrder).delete();
                if (transaction == null) {
                    aArtifact.persist("Delete empty relation order attribute for artifact: " + aArtifact.getGuid());
                } else {
                    aArtifact.persist(transaction);
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(this.getClass(), (Level)Level.INFO, (String)ex.toString(), (Throwable)ex);
        }
    }

    public void undelete() {
        this.internalUnDelete();
    }

    public void internalUnDelete() {
        this.internalSetModType(ModificationType.UNDELETED, false, true);
    }

    public void internalRemoteEventDelete() {
        this.internalDelete(false, false);
    }

    private void internalDelete(boolean reorderRelations, boolean setDirty) {
        if (!this.isDeleted()) {
            if (reorderRelations) {
                Artifact aArtifact = this.getArtifactA();
                Artifact bArtifact = this.getArtifactB();
                RelationTypeSideSorter aSorter = RelationManager.createTypeSideSorter(aArtifact, this.relationType, RelationSide.SIDE_B);
                aSorter.removeItem((ArtifactId)bArtifact);
                RelationTypeSideSorter bSorter = RelationManager.createTypeSideSorter(bArtifact, this.relationType, RelationSide.SIDE_A);
                bSorter.removeItem((ArtifactId)aArtifact);
            }
            this.internalSetModType(ModificationType.DELETED, true, setDirty);
        }
    }

    public void markAsPurged() {
        this.internalSetModType(ModificationType.DELETED, false, false);
    }

    public Artifact getArtifact(RelationSide relationSide) {
        return this.getArtifact(this.getArtifactId(relationSide));
    }

    private Artifact getArtifact(ArtifactToken artifact) {
        return ArtifactQuery.getArtifactFromToken(artifact, DeletionFlag.INCLUDE_DELETED);
    }

    public ArtifactToken getOtherSideArtifact(ArtifactId artifact) {
        return artifact.equals(this.artifactB) ? this.artifactA : this.artifactB;
    }

    public Artifact getArtifactOnOtherSide(ArtifactId artifact) {
        return this.getArtifact(this.getOtherSideArtifact(artifact));
    }

    public Artifact getArtifactA() {
        return this.getArtifact(this.artifactA);
    }

    public Artifact getArtifactB() {
        return this.getArtifact(this.artifactB);
    }

    public ArtifactToken getArtifactIdA() {
        return this.artifactA;
    }

    public ArtifactToken getArtifactIdB() {
        return this.artifactB;
    }

    public String getRationale() {
        return this.rationale;
    }

    public void setRationale(String rationale) {
        if (rationale == null) {
            rationale = "";
        }
        if (this.rationale.equals(rationale)) {
            return;
        }
        this.internalSetRationale(rationale);
        this.internalSetModType(ModificationType.MODIFIED, false, true);
    }

    public void internalSetRationale(String rationale) {
        if (rationale == null) {
            rationale = "";
        }
        if (this.rationale.equals(rationale)) {
            return;
        }
        this.rationale = rationale;
    }

    public boolean isOfType(RelationTypeToken oseeType) {
        return this.relationType.equals(oseeType);
    }

    public RelationTypeToken getRelationType() {
        return this.relationType;
    }

    public String getSidePhrasingFor(Artifact artifact) {
        return this.getSidePhrasingFor(artifact, false);
    }

    public String getSidePhrasingForOtherArtifact(Artifact artifact) {
        return this.getSidePhrasingFor(artifact, true);
    }

    private String getSidePhrasingFor(Artifact artifact, boolean isOtherArtifact) {
        RelationSide side;
        if (artifact.equals((Object)this.getArtifact(RelationSide.SIDE_A))) {
            side = RelationSide.SIDE_A;
        } else if (artifact.equals((Object)this.getArtifact(RelationSide.SIDE_B))) {
            side = RelationSide.SIDE_B;
        } else {
            throw new OseeArgumentException("Link does not contain the artifact.", new Object[0]);
        }
        if (isOtherArtifact) {
            side = side.oppositeSide();
        }
        return "has (" + this.relationType.getMultiplicity().asLimitLabel(side) + ")";
    }

    public String toString() {
        return String.format("type[%s] id[%s] modType[%s] [%s]: aId[%s] <--> bId[%s]", this.relationType.getName(), this.relationId, this.getModificationType(), this.isDirty() ? "dirty" : "not dirty", this.artifactA.getIdString(), this.artifactB.getIdString());
    }

    public void setNotDirty() {
        this.setDirtyFlag(false);
    }

    public void setDirty() {
        this.setDirtyFlag(true);
    }

    private void setDirtyFlag(boolean dirty) {
        this.dirty = dirty;
        ArtifactCache.updateCachedArtifact(this.artifactA);
        ArtifactCache.updateCachedArtifact(this.artifactB);
    }

    public void internalSetRelationId(RelationId relationId) {
        this.relationId = relationId;
    }

    public Long getId() {
        return this.relationId.getId();
    }

    public GammaId getGammaId() {
        return this.gammaId;
    }

    public boolean isInDb() {
        return this.getId() > 0L;
    }

    void internalSetGammaId(GammaId gammaId) {
        this.gammaId = gammaId;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelationLink) {
            RelationLink other = (RelationLink)obj;
            return this.equalsConceptually(other) && this.relationId == other.relationId;
        }
        return false;
    }

    public boolean equalsConceptually(RelationLink other) {
        return this.artifactA.equals(other.artifactA) && this.artifactB.equals(other.artifactB) && this.isOnSameBranch(other) && other.modificationType == this.modificationType && this.relationType.equals(other.relationType);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.branch.hashCode();
        result = 31 * result + this.artifactA.hashCode();
        result = 31 * result + this.artifactB.hashCode();
        result = 31 * result + this.relationType.hashCode();
        result = 31 * result + this.modificationType.hashCode();
        return result;
    }

    public boolean isUserDefined() {
        RelationOrderFactory factory = new RelationOrderFactory();
        Artifact aArtifact = this.getArtifactA();
        Artifact bArtifact = this.getArtifactB();
        RelationOrderData leftData = factory.createRelationOrderData(aArtifact);
        RelationOrderData rightData = factory.createRelationOrderData(bArtifact);
        RelationSorter leftSorter = leftData.getCurrentSorterGuid(this.relationType, this.getSide((ArtifactId)aArtifact));
        RelationSorter rightSorter = rightData.getCurrentSorterGuid(this.relationType, this.getSide((ArtifactId)bArtifact));
        return rightSorter.equals((Object)RelationSorter.USER_DEFINED) && leftSorter.equals((Object)RelationSorter.USER_DEFINED);
    }

    public void introduce(GammaId sourceGamma, ModificationType sourceModificationType) {
        this.internalSetPersistenceData(sourceGamma, sourceModificationType);
    }

    public boolean isUseBackingData() {
        return this.useBackingData;
    }

    public String getIdString() {
        return String.valueOf(this.getId());
    }

    public RelationId getRelationId() {
        return RelationId.valueOf((Long)this.getId());
    }
}

