/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal;

import java.util.Properties;
import org.eclipse.osee.cache.admin.CacheAdmin;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.services.IOseeCachingService;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.event.OseeEventService;

public final class ServiceUtil {
    private static IOseeCachingService cacheService;

    private ServiceUtil() {
    }

    private static <T> T getService(Class<T> clazz) {
        return (T)OsgiUtil.getService(ServiceUtil.class, clazz);
    }

    public static CacheAdmin getCacheAdmin() {
        return ServiceUtil.getService(CacheAdmin.class);
    }

    public static OseeEventService getEventService() {
        return ServiceUtil.getService(OseeEventService.class);
    }

    public static IOseeCachingService getOseeCacheService() {
        if (cacheService == null) {
            cacheService = ServiceUtil.getService(IOseeCachingService.class);
        }
        return cacheService;
    }

    public static OrcsTokenService getOrcsTokenService() {
        return ServiceUtil.getOseeCacheService().getTokenService();
    }

    public static OseeClient getOseeClient() {
        return ServiceUtil.getService(OseeClient.class);
    }

    public static boolean useOracleHints() {
        return ClientSessionManager.useOracleHints();
    }

    public static String getSql(OseeSql sqlEnum) {
        Properties properties = ClientSessionManager.getSqlProperties();
        String sql = properties.getProperty(sqlEnum.toString());
        if (sql != null) {
            return sql;
        }
        throw new OseeArgumentException("Invalid sql key [%s]", new Object[]{sqlEnum.toString()});
    }
}

