/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureSearchEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceStructureSearchEndpointImpl
implements InterfaceStructureSearchEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceElementArrayApi interfaceElementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceStructureSearchEndpointImpl(BranchId branch, UserId account, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceElementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getAllStructures() {
        try {
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAll(this.branch, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
                elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
                for (InterfaceStructureElementToken element : elements) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                }
                structure.setElements(elements);
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureToken>();
        }
    }

    private List<AttributeTypeId> createStructureAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceStructureCategory);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMinSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMaxSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceTaskFileType);
        return attributes;
    }

    @Override
    public Collection<InterfaceStructureToken> getFilteredStructures(String filter) {
        List<AttributeTypeId> structureAttributes = this.createStructureAttributeList();
        try {
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAllByFilter(this.branch, filter, structureAttributes, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
                elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
                for (InterfaceStructureElementToken element : elements) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                }
                structure.setElements(elements);
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureToken>();
        }
    }
}

