/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserTokenSerializer;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.NamedIdBase;
import org.eclipse.osee.framework.jdk.core.util.Strings;

@JsonSerialize(using=UserTokenSerializer.class)
public interface UserToken
extends ArtifactToken,
UserId {
    public static final UserToken SENTINEL = UserToken.create(Id.SENTINEL, "Sentinel", "", "", false);

    @JsonCreator
    public static UserToken create(@JsonProperty(value="name") String name, @JsonProperty(value="email") String email, @JsonProperty(value="userId") String userId) {
        return UserToken.create(Id.SENTINEL, name, email, userId, true);
    }

    public static UserToken create(long id, String name, String email, String userId, boolean active) {
        return UserToken.create(id, name, email, userId, active, Collections.emptyList());
    }

    public static UserToken create(long id, String name, String email, String userId, boolean active, List<IUserGroupArtifactToken> roles) {
        return new UserTokenImpl(id, name, userId, active, email, Arrays.asList(userId), roles, "");
    }

    public static @NonNull UserToken create(long id, String name, String email, String userId, boolean active, List<String> loginIds, List<IUserGroupArtifactToken> roles) {
        return new UserTokenImpl(id, name, userId, active, email, loginIds, roles, "");
    }

    public static UserToken create(long id, String name, String email, String userId, boolean active, List<String> loginIds, List<IUserGroupArtifactToken> roles, String phone) {
        return new UserTokenImpl(id, name, userId, active, email, loginIds, roles, phone);
    }

    public String getUserId();

    public boolean isActive();

    public boolean isOseeAdmin();

    public String getPhone();

    public String getEmail();

    public List<IUserGroupArtifactToken> getRoles();

    public List<String> getLoginIds();

    public ArtifactToken getArtifact();

    public void setArtifact(ArtifactToken var1);

    public static final class UserTokenImpl
    extends NamedIdBase
    implements UserToken {
        private final String userId;
        private final boolean active;
        private final boolean admin;
        private final String email;
        private final List<IUserGroupArtifactToken> roles;
        private final List<String> loginIds;
        private final String phone;
        private ArtifactToken artifact;

        public UserTokenImpl(long id, String name, String userId, boolean active, String email, List<String> loginIds, List<IUserGroupArtifactToken> roles, String phone) {
            super(Long.valueOf(id), name);
            this.userId = userId;
            this.active = active;
            this.email = email;
            this.loginIds = loginIds;
            this.roles = roles;
            this.admin = this.roles.contains(CoreUserGroups.OseeAdmin);
            this.phone = phone;
        }

        @Override
        public ArtifactTypeToken getArtifactType() {
            return CoreArtifactTypes.User;
        }

        @Override
        public String getUserId() {
            return this.userId;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public boolean isOseeAdmin() {
            return this.admin;
        }

        @Override
        public String getEmail() {
            return this.email;
        }

        @Override
        public String getPhone() {
            return this.phone;
        }

        @Override
        public List<IUserGroupArtifactToken> getRoles() {
            return this.roles;
        }

        public String toString() {
            return String.format("UserToken [name [%s], userId=[%s], active=[%s], email=[%s], loginIds=[%s], roles=[%s]", this.getName(), this.userId, this.active, this.email, this.getLoginIds(), this.getRoles());
        }

        @Override
        public BranchToken getBranch() {
            return CoreBranches.COMMON;
        }

        @Override
        public List<String> getLoginIds() {
            return this.loginIds;
        }

        @Override
        public ArtifactToken getArtifact() {
            return this.artifact;
        }

        @Override
        public void setArtifact(ArtifactToken artifact) {
            this.artifact = artifact;
        }

        public int hashCode() {
            if (Strings.isValid((String)this.userId)) {
                return this.userId.hashCode();
            }
            return this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof UserToken && Strings.isValid((String)this.userId) && Strings.isValid((String)((UserToken)obj).getUserId())) {
                return this.userId.equals(((UserToken)obj).getUserId());
            }
            return super.equals(obj);
        }
    }
}

