/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mail.api.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.internet.MimeMultipart;

public class MultiPartDataSource
implements MultipartDataSource {
    private final String name;
    private final MimeMultipart content;

    public MultiPartDataSource(String name, MimeMultipart content) {
        this.name = name;
        this.content = content;
    }

    public String getContentType() {
        return this.content.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.content.writeTo((OutputStream)os);
        }
        catch (MessagingException ex) {
            throw new IOException(ex);
        }
        return new ByteArrayInputStream(os.toByteArray());
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("OutputStream is not available for this source");
    }

    public int getCount() {
        try {
            return this.content.getCount();
        }
        catch (MessagingException messagingException) {
            return 0;
        }
    }

    public BodyPart getBodyPart(int index) throws MessagingException {
        return this.content.getBodyPart(index);
    }
}

