/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.server.ide;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.framework.core.server.UnsecuredOseeHttpServlet;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class AdminServlet
extends UnsecuredOseeHttpServlet {
    private static final long serialVersionUID = -4391079960307521104L;
    private final BundleContext context;

    public AdminServlet(Log logger, BundleContext context) {
        super(logger);
        this.context = context;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        PrintWriter writer = resp.getWriter();
        Map<String, CommandProvider> cmds = AdminServlet.getCommands(this.context);
        for (CommandProvider commandProvider : cmds.values()) {
            writer.append(commandProvider.getHelp());
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String cmd = req.getParameter("cmd");
        String argList = req.getParameter("args");
        List<Object> args = Strings.isValid((String)argList) ? Arrays.asList(argList.split(",")) : Collections.emptyList();
        resp.setStatus(200);
        HttpCommandInterpreter interpreter = new HttpCommandInterpreter(this.context, resp.getWriter(), args.iterator());
        Object object = interpreter.execute(cmd);
        if (object instanceof Job) {
            Job job = (Job)object;
            try {
                job.join();
                IStatus status = job.getResult();
                interpreter.println(status.toString());
            }
            catch (InterruptedException ex) {
                interpreter.print(ex);
            }
        } else if (object instanceof Future) {
            Future future = (Future)object;
            try {
                future.get();
            }
            catch (Exception ex) {
                interpreter.print(ex);
            }
        }
    }

    private static String commandKey(String rawCommand) {
        return "_" + rawCommand;
    }

    private static Map<String, CommandProvider> getCommands(BundleContext context) {
        HashMap<String, CommandProvider> data = new HashMap<String, CommandProvider>();
        ServiceTracker tracker = new ServiceTracker(context, CommandProvider.class, null);
        tracker.open(true);
        try {
            Object[] services;
            Object[] objectArray = services = tracker.getServices();
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Object service = objectArray[n2];
                CommandProvider commandProvider = (CommandProvider)service;
                Method[] methodArray = commandProvider.getClass().getMethods();
                int n3 = methodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Method method = methodArray[n4];
                    String methodName = method.getName();
                    if (methodName.startsWith("_")) {
                        data.put(methodName, commandProvider);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        finally {
            OsgiUtil.close((ServiceTracker)tracker);
        }
        return data;
    }

    private static final class HttpCommandInterpreter
    implements CommandInterpreter {
        private final Writer writer;
        private final BundleContext context;
        private final Iterator<String> args;

        public HttpCommandInterpreter(BundleContext context, Writer writer, Iterator<String> args) {
            this.writer = writer;
            this.context = context;
            this.args = args;
        }

        public String nextArgument() {
            return this.args.hasNext() ? this.args.next() : null;
        }

        public Object execute(String cmd) {
            String methodName = AdminServlet.commandKey(cmd);
            Map commands = AdminServlet.getCommands(this.context);
            CommandProvider commandProvider = (CommandProvider)commands.get(methodName);
            Class<?> providerClass = commandProvider.getClass();
            Object toReturn = null;
            try {
                Method method = providerClass.getMethod(methodName, CommandInterpreter.class);
                toReturn = method.invoke((Object)commandProvider, this);
            }
            catch (Exception ex) {
                this.print(ex);
            }
            return toReturn;
        }

        public void print(Object o) {
            this.print(String.valueOf(o));
        }

        public void println() {
            this.print("\n");
        }

        public void println(Object o) {
            this.print(String.format("%s\n", o));
        }

        public void printStackTrace(Throwable t) {
            this.print(Lib.exceptionToString((Throwable)t));
        }

        public void printDictionary(Dictionary dic, String title) {
            this.print(String.format("%s:[%s]", title, dic));
        }

        public void printBundleResource(Bundle bundle, String resource) {
            this.print(String.format("[%s:%s]", bundle, resource));
        }

        private void print(String message) {
            try {
                this.writer.append(message);
            }
            catch (Exception exception) {}
        }
    }
}

