/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.transaction;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.jdbc.SqlTable;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.BranchCategoryData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.graph.GraphData;
import org.eclipse.osee.orcs.core.internal.relation.Relation;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.HasSession;

public class TxData
implements HasSession,
HasBranchId {
    private final OrcsSession session;
    private final GraphData graph;
    private final List<TupleData> tuples = new ArrayList<TupleData>();
    private final List<BranchCategoryData> categories = new ArrayList<BranchCategoryData>();
    private final HashCollection<SqlTable, GammaId> tuplesToDelete = new HashCollection();
    private final List<GammaId> branchCategoriesToDelete = new ArrayList<GammaId>();
    private final HashMap<Long, Artifact> writeables = new HashMap();
    private final HashMap<Long, ArtifactReadable> readables = new HashMap();
    private final Set<Relation> relations = new HashSet<Relation>();
    private UserId author;
    private String comment;
    private volatile boolean isCommitInProgress;
    private volatile TxState txState;

    public TxData(OrcsSession session, GraphData graph) {
        this.session = session;
        this.graph = graph;
        this.txState = TxState.NEW_TX;
    }

    public void clear() {
        this.isCommitInProgress = false;
        this.writeables.clear();
        this.readables.clear();
    }

    public OrcsSession getSession() {
        return this.session;
    }

    public BranchId getBranch() {
        return this.graph.getBranch();
    }

    public GraphData getGraph() {
        return this.graph;
    }

    public UserId getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public TxState getTxState() {
        return this.txState;
    }

    public boolean isCommitInProgress() {
        return this.isCommitInProgress;
    }

    public void setAuthor(UserId author) {
        this.author = author;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setTxState(TxState txState) {
        this.txState = txState;
    }

    public void setCommitInProgress(boolean isCommitInProgress) {
        this.isCommitInProgress = isCommitInProgress;
    }

    public Artifact add(Artifact artifact) {
        return this.writeables.put(artifact.getId(), artifact);
    }

    public void add(ArtifactReadable artifact) {
        this.readables.put(artifact.getId(), artifact);
    }

    public void add(TupleData tupleData) {
        this.tuples.add(tupleData);
    }

    public List<TupleData> getTuplesToAdd() {
        return this.tuples;
    }

    public void deleteTuple(SqlTable tupleTable, GammaId gammaId) {
        this.tuplesToDelete.put((Object)tupleTable, (Object)gammaId);
    }

    public void deleteBranchCategory(GammaId gammaId) {
        this.branchCategoriesToDelete.add(gammaId);
    }

    public List<GammaId> getBranchCategoriesToDelete() {
        return this.branchCategoriesToDelete;
    }

    public HashCollection<SqlTable, GammaId> getTuplesToDelete() {
        return this.tuplesToDelete;
    }

    public void add(BranchCategoryData categoryData) {
        this.categories.add(categoryData);
    }

    public List<BranchCategoryData> getCategoriesToAdd() {
        return this.categories;
    }

    public Iterable<Artifact> getAllWriteables() {
        return this.writeables.values();
    }

    public Artifact getWriteable(ArtifactId artifactId) {
        return this.writeables.get(artifactId.getId());
    }

    public ArtifactReadable getReadable(ArtifactId artifactId) {
        return this.readables.get(artifactId.getId());
    }

    public String toString() {
        return "TxData [session=" + this.session + ", graph=" + this.graph + ", author=" + this.author + ", comment=" + this.comment + ", isCommitInProgress=" + this.isCommitInProgress + ", txState=" + (Object)((Object)this.txState) + "]";
    }

    public Set<Relation> getRelations() {
        return this.relations;
    }

    public void addRelation(Relation relation) {
        this.relations.add(relation);
    }

    public static enum TxState {
        NEW_TX,
        COMMIT_STARTED,
        COMMITTED,
        COMMIT_FAILED;

    }
}

