/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.access;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IRelationLink;
import org.eclipse.osee.framework.core.data.IUserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserGroupArtifactToken;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.util.AbstractUserGroupImpl;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class UserGroupImpl
extends AbstractUserGroupImpl {
    public UserGroupImpl(ArtifactToken userGroupArt) {
        super(userGroupArt);
    }

    public ArtifactTypeToken getArtifactType() {
        return CoreArtifactTypes.UserGroup;
    }

    public ArtifactReadable getArtifact() {
        this.checkGroupExists();
        if (this.groupArtifact instanceof ArtifactReadable) {
            return (ArtifactReadable)this.groupArtifact;
        }
        return null;
    }

    public boolean addMember(UserId user, boolean persist) {
        throw new UnsupportedOperationException();
    }

    public boolean isMember(UserId user) {
        this.checkGroupExists();
        Conditions.assertTrue((boolean)(user instanceof ArtifactReadable), (String)"User must be artifact", (Object[])new Object[0]);
        return this.getArtifact().areRelated(CoreRelationTypes.Users_User, (ArtifactReadable)user);
    }

    public boolean isMember(Long id) {
        this.checkGroupExists();
        for (IRelationLink rel : this.getArtifact().getRelations(CoreRelationTypes.Users_User)) {
            if (rel.getArtIdB() != id.intValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isCurrentUserMember() {
        throw new UnsupportedOperationException();
    }

    protected ArtifactReadable getOrCreateGroupArtifact(ArtifactToken token) {
        throw new UnsupportedOperationException();
    }

    public boolean removeMember(UserId user, boolean persist) {
        throw new UnsupportedOperationException();
    }

    public Collection<UserToken> getMembers() {
        this.checkGroupExists();
        ArrayList<UserToken> users = new ArrayList<UserToken>();
        for (ArtifactReadable userArt : this.getArtifact().getRelated(CoreRelationTypes.Users_User).getList()) {
            String name = userArt.getName();
            String email = (String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Email, (Object)"");
            String userId = (String)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.UserId);
            boolean active = (Boolean)userArt.getSoleAttributeValue((AttributeTypeToken)CoreAttributeTypes.Active);
            ArrayList<IUserGroupArtifactToken> roles = new ArrayList<IUserGroupArtifactToken>();
            for (ArtifactReadable userGroupArt : userArt.getRelated(CoreRelationTypes.Users_Artifact).getList()) {
                IUserGroupArtifactToken userGroup = UserGroupArtifactToken.valueOf((Long)userGroupArt.getId(), (String)userGroupArt.getName());
                roles.add(userGroup);
            }
            UserToken userToken = UserToken.create((long)userArt.getId(), (String)name, (String)email, (String)userId, (boolean)active, roles);
            users.add(userToken);
        }
        return users;
    }

    public BranchToken getBranch() {
        return this.getArtifact().getBranch();
    }
}

