/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal;

import java.util.Arrays;
import org.eclipse.osee.framework.core.applicability.FeatureDefinition;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.ConfigurationGroupDefinition;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTokens;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreBranchCategoryTokens;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.OrcsBranch;
import org.eclipse.osee.orcs.core.internal.applicability.DemoFeatures;
import org.eclipse.osee.orcs.core.util.Artifacts;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;
import org.eclipse.osee.orcs.transaction.TransactionFactory;

public class CreateDemoBranches {
    private final OrcsApi orcsApi;
    private final TransactionFactory txFactory;
    private final OrcsBranch branchOps;

    public CreateDemoBranches(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
        this.txFactory = orcsApi.getTransactionFactory();
        this.branchOps = orcsApi.getBranchOps();
    }

    public void populate() {
        this.orcsApi.userService().createUsers((Iterable)DemoUsers.values(), "Create Demo Users");
        UserToken account = DemoUsers.Joe_Smith;
        this.createDemoProgramBranch(DemoBranches.SAW_Bld_1, (UserId)account);
        this.createDemoProgramBranch(DemoBranches.CIS_Bld_1, (UserId)account);
        this.branchOps.createBaselineBranch(DemoBranches.SAW_PL, (ArtifactId)account, DemoBranches.SAW_Bld_1, ArtifactId.SENTINEL);
        CreateDemoBranches.createProductLineConfig((BranchId)DemoBranches.SAW_PL, (UserId)account, this.orcsApi);
        Branch hardeningBranch = this.branchOps.createBaselineBranch(DemoBranches.SAW_PL_Hardening_Branch, (ArtifactId)account, DemoBranches.SAW_PL, ArtifactId.SENTINEL);
        this.orcsApi.getAccessControlService().removePermissions((BranchId)hardeningBranch);
        this.branchOps.createWorkingBranch(DemoBranches.SAW_PL_Working_Branch, (ArtifactId)account, DemoBranches.SAW_PL, ArtifactId.SENTINEL);
    }

    public static void createProductLineConfig(BranchId branch, UserId account, OrcsApi orcsApi) {
        TransactionBuilder tx = orcsApi.getTransactionFactory().createTransaction(branch, "Create Product Line folders");
        ArtifactToken plFolder = Artifacts.getOrCreate(CoreArtifactTokens.ProductLineFolder, (ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, tx, orcsApi);
        Artifacts.getOrCreate(CoreArtifactTokens.ProductsFolder, (ArtifactId)plFolder, tx, orcsApi);
        ArtifactToken featuresFolder = Artifacts.getOrCreate(CoreArtifactTokens.FeaturesFolder, (ArtifactId)plFolder, tx, orcsApi);
        Artifacts.getOrCreate(CoreArtifactTokens.PlCfgGroupsFolder, (ArtifactId)plFolder, tx, orcsApi);
        ArtifactToken productA = tx.createView(branch, "Product A");
        ArtifactToken productB = tx.createView(branch, "Product B");
        ArtifactToken productC = tx.createView(branch, "Product C");
        ArtifactToken productD = tx.createView(branch, "Product D");
        ArtifactToken[] products = new ArtifactToken[]{productA, productB, productC, productD};
        CreateDemoBranches.createFeatureConfigs((ArtifactId)featuresFolder, tx, orcsApi);
        CreateDemoBranches.configureFeature(tx, DemoFeatures.ROBOT_ARM_LIGHT.name(), (ArtifactId[])products, "Excluded", "Included", "Excluded", "Excluded");
        CreateDemoBranches.configureFeature(tx, DemoFeatures.ENGINE_5.name(), (ArtifactId[])products, "A2543", "A2543", "A2543", "B5543");
        CreateDemoBranches.configureFeature(tx, DemoFeatures.JHU_CONTROLLER.name(), (ArtifactId[])products, "Excluded", "Included", "Included", "Excluded");
        CreateDemoBranches.configureFeature(tx, DemoFeatures.ROBOT_SPEAKER.name(), (ArtifactId[])products, "SPKR_A", "SPKR_A", "SPKR_B", "SPKR_B");
        CreateDemoBranches.createLegacyFeatureConfig((ArtifactId)featuresFolder, tx);
        tx.createBranchCategory(branch, CoreBranchCategoryTokens.PLE);
        tx.createBranchCategory(branch, CoreBranchCategoryTokens.ATS);
        tx.commit();
        ConfigurationGroupDefinition group = new ConfigurationGroupDefinition();
        group.setName("abGroup");
        orcsApi.getApplicabilityOps().createCfgGroup(group, branch, account);
        orcsApi.getApplicabilityOps().relateCfgGroupToView("abGroup", "Product A", branch, account);
        orcsApi.getApplicabilityOps().relateCfgGroupToView("abGroup", "Product B", branch, account);
        orcsApi.getApplicabilityOps().syncConfigGroup(branch, account);
    }

    private static void createFeatureConfigs(ArtifactId folder, TransactionBuilder tx, OrcsApi orcsApi) {
        XResultData results = new XResultData();
        FeatureDefinition def1 = new FeatureDefinition(DemoFeatures.ROBOT_ARM_LIGHT.name(), "String", Arrays.asList("Included", "Excluded"), "Included", false, "A significant capability", Arrays.asList("Test"));
        orcsApi.getApplicabilityOps().createFeatureDefinition(def1, tx, results);
        FeatureDefinition def2 = new FeatureDefinition(DemoFeatures.ENGINE_5.name(), "String", Arrays.asList("A2543", "B5543"), "A2543", false, "Used select type of engine", Arrays.asList("Test"));
        orcsApi.getApplicabilityOps().createFeatureDefinition(def2, tx, results);
        FeatureDefinition def3 = new FeatureDefinition(DemoFeatures.JHU_CONTROLLER.name(), "String", Arrays.asList("Included", "Excluded"), "Included", false, "A small point of variation", null);
        orcsApi.getApplicabilityOps().createFeatureDefinition(def3, tx, results);
        FeatureDefinition def4 = new FeatureDefinition(DemoFeatures.ROBOT_SPEAKER.name(), "String", Arrays.asList("SPKR_A", "SPKR_B", "SPKR_C"), "SPKR_A", true, "This feature is multi-select.", null);
        orcsApi.getApplicabilityOps().createFeatureDefinition(def4, tx, results);
        orcsApi.getApplicabilityOps();
        Conditions.assertFalse((boolean)results.isErrors(), (String)results.toString(), (Object[])new Object[0]);
    }

    private static void createLegacyFeatureConfig(ArtifactId folder, TransactionBuilder tx) {
        ArtifactToken featureDefinition = tx.createArtifact(folder, CoreArtifactTypes.FeatureDefinition, "Feature Definition_SAW_Bld_1");
        String featureDefJson = "[{\"name\": \"" + DemoFeatures.ROBOT_ARM_LIGHT.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"Included\", \"Excluded\"]," + "\"defaultValue\": \"Included\"," + "\"description\": \"Test It\"" + "}, {" + "\"name\": \"" + DemoFeatures.ENGINE_5.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"A2543\", \"B5543\"]," + "\"defaultValue\": \"A2543\"," + "\"description\": \"Test It\"" + "},{" + "\"name\": \"" + DemoFeatures.JHU_CONTROLLER.name() + "\"," + "\"type\": \"single\"," + "\"values\": [\"Included\", \"Excluded\"]," + "\"defaultValue\": \"Excluded\"," + "\"description\": \"Test It\"" + "},{" + "\"name\": \"" + DemoFeatures.ROBOT_SPEAKER.name() + "\"," + "\"type\": \"multiple\"," + "\"values\": [\"SPKR_A\", \"SPKR_B\", \"SPKR_C\"]," + "\"defaultValue\": \"SPKR_A\"," + "\"description\": \"Test It\"" + "}" + "]";
        tx.createAttribute((ArtifactId)featureDefinition, (AttributeTypeToken)CoreAttributeTypes.GeneralStringData, (Object)featureDefJson);
    }

    private static void configureFeature(TransactionBuilder tx, String featureName, ArtifactId[] products, String ... featureValues) {
        int i = 0;
        while (i < products.length) {
            tx.addTuple2(CoreTupleTypes.ViewApplicability, (Object)products[i], (Object)(String.valueOf(featureName) + " = " + featureValues[i]));
            ++i;
        }
    }

    private void createDemoProgramBranch(BranchToken branch, UserId account) {
        this.branchOps.createProgramBranch(branch, account);
        TransactionBuilder tx = this.txFactory.createTransaction((BranchId)branch, account, "Create SAW Product Decomposition");
        ArtifactToken sawProduct = tx.createArtifact((ArtifactId)CoreArtifactTokens.DefaultHierarchyRoot, CoreArtifactTypes.Component, "SAW Product Decomposition");
        for (String subsystem : DemoSubsystems.getSubsystems()) {
            tx.createArtifact((ArtifactId)sawProduct, CoreArtifactTypes.Component, subsystem);
        }
        tx.commit();
    }
}

