/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.ds;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.Branch;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.executor.CancellableCallable;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ApplicabilityDsQuery;
import org.eclipse.osee.orcs.core.ds.LoadDataHandler;
import org.eclipse.osee.orcs.core.ds.QueryData;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.data.TransactionReadable;
import org.eclipse.osee.orcs.search.QueryFactory;
import org.eclipse.osee.orcs.search.TupleQuery;

public interface QueryEngine {
    public int getArtifactCount(QueryData var1);

    public void runArtifactQuery(QueryData var1, LoadDataHandler var2) throws Exception;

    public int getBranchCount(QueryData var1);

    public void runBranchQuery(QueryData var1, List<? super Branch> var2);

    public TupleQuery createTupleQuery();

    public ApplicabilityDsQuery createApplicabilityDsQuery();

    public int getTxCount(QueryData var1);

    public void runTxQuery(QueryData var1, List<? super TransactionReadable> var2);

    public CancellableCallable<Integer> createQuery(OrcsSession var1, QueryData var2, LoadDataHandler var3);

    public List<ArtifactToken> asArtifactTokens(QueryData var1);

    public List<Map<String, Object>> asArtifactMaps(QueryData var1);

    public Map<ArtifactId, ArtifactToken> asArtifactTokenMap(QueryData var1);

    public List<ArtifactId> asArtifactIds(QueryData var1);

    public Map<ArtifactId, ArtifactReadable> asArtifactMap(QueryData var1, QueryFactory var2);

    public List<ArtifactReadable> asArtifact(QueryData var1, QueryFactory var2);

    public List<ArtifactReadable> asArtifacts(QueryData var1, QueryFactory var2);

    public boolean isArchived(BranchId var1);

    public void getBranchCategoryGammaIds(Consumer<GammaId> var1, BranchId var2, BranchCategoryToken var3);
}

