/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.loader;

import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.BranchCategoryToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.RelationalConstants;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.Tuple2Type;
import org.eclipse.osee.framework.core.data.Tuple3Type;
import org.eclipse.osee.framework.core.data.Tuple4Type;
import org.eclipse.osee.framework.core.data.TupleTypeId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.ds.BranchCategoryData;
import org.eclipse.osee.orcs.core.ds.DataFactory;
import org.eclipse.osee.orcs.core.ds.OrcsData;
import org.eclipse.osee.orcs.core.ds.RelationData;
import org.eclipse.osee.orcs.core.ds.TupleData;
import org.eclipse.osee.orcs.core.ds.VersionData;
import org.eclipse.osee.orcs.db.internal.IdentityManager;
import org.eclipse.osee.orcs.db.internal.OrcsObjectFactory;
import org.eclipse.osee.orcs.db.internal.loader.data.TupleDataImpl;

public class DataFactoryImpl
implements DataFactory {
    private final IdentityManager idFactory;
    private final OrcsObjectFactory objectFactory;

    public DataFactoryImpl(IdentityManager idFactory, OrcsObjectFactory objectFactory) {
        this.idFactory = idFactory;
        this.objectFactory = objectFactory;
    }

    public ArtifactData create(BranchId branch, ArtifactTypeToken token, String guid) {
        return this.create(branch, token, guid, this.idFactory.getNextArtifactId());
    }

    public ArtifactData create(BranchId branch, ArtifactTypeToken token, String guid, ApplicabilityId appId) {
        return this.create(branch, token, guid, this.idFactory.getNextArtifactId(), appId);
    }

    public ArtifactData create(BranchId branch, ArtifactTypeToken token, Long artifactId) {
        return this.create(branch, token, null, artifactId);
    }

    public ArtifactData create(BranchId branch, ArtifactTypeToken token, Long artifactId, ApplicabilityId appId) {
        return this.create(branch, token, null, artifactId, appId);
    }

    public ArtifactData create(BranchId branchId, ArtifactTypeToken token, String guid, long artifactId) {
        return this.create(branchId, token, guid, artifactId, ApplicabilityId.BASE);
    }

    public ArtifactData create(BranchId branchId, ArtifactTypeToken token, String guid, long artifactId, ApplicabilityId appId) {
        Conditions.checkNotNull((Object)branchId, (String)"branch");
        Conditions.checkExpressionFailOnTrue((boolean)token.isAbstract(), (String)"Cannot create an instance of abstract type [%s]", (Object[])new Object[]{token});
        String guidToSet = this.idFactory.getUniqueGuid(guid);
        Conditions.checkExpressionFailOnTrue((!GUID.isValid((String)guidToSet) ? 1 : 0) != 0, (String)"Invalid guid [%s] during artifact creation [type: %s]", (Object[])new Object[]{guidToSet, token});
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setBranch(branchId);
        ModificationType modType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
        ArtifactData artifactData = this.objectFactory.createArtifactData(version, (Integer)((int)artifactId), token, modType, guidToSet, appId);
        return artifactData;
    }

    public ArtifactData copy(BranchId destination, ArtifactData source) {
        ArtifactData copy = this.objectFactory.createCopy(source);
        this.updateDataForCopy(destination, (OrcsData)copy);
        copy.setGuid(this.idFactory.getUniqueGuid(null));
        copy.setLocalId(Integer.valueOf(this.idFactory.getNextArtifactId()));
        return copy;
    }

    public AttributeData introduce(BranchId destination, AttributeData source) {
        AttributeData newVersion = this.objectFactory.createCopy(source);
        newVersion.setUseBackingData(true);
        this.updateDataForIntroduce(destination, (OrcsData)newVersion);
        return newVersion;
    }

    public AttributeData create(ArtifactData parent, AttributeTypeGeneric attributeType) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setBranch(parent.getVersion().getBranch());
        ModificationType modType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
        return this.objectFactory.createAttributeData(version, this.idFactory.getNextAttributeId(), attributeType, modType, (ArtifactId)parent, ApplicabilityId.BASE);
    }

    public AttributeData copy(BranchId destination, AttributeData orcsData) {
        AttributeData copy = this.objectFactory.createCopy(orcsData);
        this.updateDataForCopy(destination, (OrcsData)copy);
        copy.setLocalId(RelationalConstants.DEFAULT_ITEM_ID);
        return copy;
    }

    public ArtifactData introduce(BranchId destination, ArtifactData source) {
        ArtifactData newVersion = this.objectFactory.createCopy(source);
        newVersion.setUseBackingData(true);
        this.updateDataForIntroduce(destination, (OrcsData)newVersion);
        return newVersion;
    }

    public RelationData createRelationData(RelationTypeToken relationType, BranchId branch, ArtifactId aArtifact, ArtifactId bArtifact, String rationale) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setBranch(branch);
        ModificationType modType = RelationalConstants.DEFAULT_MODIFICATION_TYPE;
        return this.objectFactory.createRelationData(version, this.idFactory.getNextRelationId(), relationType, modType, aArtifact, bArtifact, rationale, ApplicabilityId.BASE);
    }

    public TupleData introduceTupleData(TupleTypeId tupleType, GammaId tupleGamma) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        version.setGammaId(tupleGamma);
        TupleDataImpl tupleData = new TupleDataImpl(version);
        tupleData.setTupleType(tupleType);
        tupleData.setApplicabilityId(ApplicabilityId.BASE);
        tupleData.setUseBackingData(true);
        tupleData.setModType(ModificationType.INTRODUCED);
        return tupleData;
    }

    public TupleData createTuple2Data(Tuple2Type<?, ?> tupleType, BranchId branch, Long e1, Long e2) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        TupleData tupleData = this.objectFactory.createTuple2Data(version, branch, tupleType, e1, e2);
        return tupleData;
    }

    public BranchCategoryData createBranchCategoryData(BranchId branch, BranchCategoryToken category) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        BranchCategoryData categoryData = this.objectFactory.createBranchCategoryData(version, branch, category);
        return categoryData;
    }

    public TupleData createTuple3Data(Tuple3Type<?, ?, ?> tupleType, BranchId branch, Long e1, Long e2, Long e3) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        TupleData tupleData = this.objectFactory.createTuple3Data(version, branch, tupleType, e1, e2, e3);
        return tupleData;
    }

    public TupleData createTuple4Data(Tuple4Type<?, ?, ?, ?> tupleType, BranchId branch, Long e1, Long e2, Long e3, Long e4) {
        VersionData version = this.objectFactory.createDefaultVersionData();
        TupleData tupleData = this.objectFactory.createTuple4Data(version, branch, tupleType, e1, e2, e3, e4);
        return tupleData;
    }

    public RelationData introduce(BranchId destination, RelationData source) {
        RelationData newVersion = this.objectFactory.createCopy(source);
        newVersion.setUseBackingData(true);
        this.updateDataForIntroduce(destination, (OrcsData)newVersion);
        return newVersion;
    }

    public ArtifactData clone(ArtifactData source) {
        return this.objectFactory.createCopy(source);
    }

    public AttributeData clone(AttributeData source) {
        return this.objectFactory.createCopy(source);
    }

    public RelationData clone(RelationData source) {
        return this.objectFactory.createCopy(source);
    }

    private <T extends Id> void updateDataForCopy(BranchId destination, OrcsData<T> data) {
        VersionData version = data.getVersion();
        version.setBranch(destination);
        version.setTransactionId(TransactionId.SENTINEL);
        version.setStripeId(TransactionId.SENTINEL);
        version.setHistorical(false);
        version.setGammaId(GammaId.SENTINEL);
        data.setModType(ModificationType.NEW);
    }

    private <T extends Id> void updateDataForIntroduce(BranchId destination, OrcsData<T> data) {
        VersionData version = data.getVersion();
        version.setBranch(destination);
        version.setHistorical(false);
        version.setTransactionId(TransactionId.SENTINEL);
    }
}

