/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.osee.define.api.CertBaselineData;
import org.eclipse.osee.define.api.CertFileData;
import org.eclipse.osee.define.api.TraceData;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.data.UserId;

@Path(value="trace")
public interface TraceabilityEndpoint {
    @GET
    @Path(value="highlowtrace")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    public Response getLowHighReqReport(@QueryParam(value="branch") BranchId var1, @QueryParam(value="selected_types") String var2);

    @GET
    @Path(value="srs-impd/{branch}")
    @Produces(value={"application/json"})
    public TraceData getSrsToImpd(@PathParam(value="branch") BranchId var1, @DefaultValue(value="-1") @QueryParam(value="excludeType") ArtifactTypeId var2);

    @GET
    @Path(value="ui")
    @Produces(value={"text/html"})
    public String getSinglePageApp();

    @GET
    @Path(value="pidsVerification")
    @Consumes(value={"application/json"})
    @Produces(value={"application/xml"})
    public Response getPidsVerificationReport(@QueryParam(value="branch") BranchId var1, @QueryParam(value="rootArtifact") ArtifactId var2);

    @POST
    @Path(value="cert/{branch}/repo/{repository-name}/files")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ArtifactId baselineFiles(@PathParam(value="branch") BranchId var1, @PathParam(value="repository-name") String var2, @HeaderParam(value="osee.account.id") UserId var3, CertBaselineData var4);

    @GET
    @Path(value="cert/{branch}/{artifact}")
    @Produces(value={"application/json"})
    public CertBaselineData getBaselineData(@PathParam(value="branch") BranchId var1, @PathParam(value="artifact") ArtifactId var2);

    @GET
    @Path(value="cert/{branch}/repo/{repository-name}")
    @Produces(value={"application/json"})
    public List<CertBaselineData> getBaselineData(@PathParam(value="branch") BranchId var1, @PathParam(value="repository-name") String var2);

    @POST
    @Path(value="cert/{destination-branch}/repo/{repository-name}/{source-branch}")
    @Produces(value={"application/json"})
    public TransactionToken copyCertBaselineData(@HeaderParam(value="osee.account.id") UserId var1, @PathParam(value="destination-branch") BranchId var2, @PathParam(value="repository-name") String var3, @PathParam(value="source-branch") BranchId var4);

    @GET
    @Path(value="cert/{branch}/repo/{repository-name}/files")
    @Produces(value={"application/json"})
    public List<CertFileData> getCertFileData(@PathParam(value="branch") BranchId var1, @PathParam(value="repository-name") String var2);
}

