/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.util.IAtsStoreService;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogFactory;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateFactory;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.workflow.WorkItem;
import org.eclipse.osee.ats.rest.internal.util.AtsChangeSet;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.search.QueryBuilder;

public class AtsStoreServiceImpl
implements IAtsStoreService {
    private final OrcsApi orcsApi;
    private final IAtsStateFactory stateFactory;
    private final IAtsLogFactory logFactory;
    private final AtsApi atsApi;
    private final JdbcService jdbcService;

    public AtsStoreServiceImpl(AtsApi atsApi, OrcsApi orcsApi, IAtsStateFactory stateFactory, IAtsLogFactory logFactory) {
        this.atsApi = atsApi;
        this.orcsApi = orcsApi;
        this.logFactory = logFactory;
        this.stateFactory = stateFactory;
        this.jdbcService = atsApi.getJdbcService();
    }

    public JdbcService getJdbcService() {
        return this.jdbcService;
    }

    public IAtsChangeSet createAtsChangeSet(String comment, AtsUser asUser) {
        return this.createAtsChangeSet(comment, (BranchId)this.atsApi.getAtsBranch(), asUser);
    }

    public IAtsChangeSet createAtsChangeSet(String comment, BranchId branch, AtsUser asUser) {
        return new AtsChangeSet(this.atsApi, this.atsApi.getAttributeResolver(), this.orcsApi, this.stateFactory, this.logFactory, comment, asUser, branch);
    }

    public QueryBuilder getQuery() {
        return this.orcsApi.getQueryFactory().fromBranch((BranchId)this.atsApi.getAtsBranch());
    }

    public List<IAtsWorkItem> reload(Collection<IAtsWorkItem> inWorkWorkflows) {
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>(inWorkWorkflows.size());
        List ids = AtsObjects.toArtifactIds(inWorkWorkflows);
        Iterator arts = this.getQuery().andIds((Collection)ids).getResults().iterator();
        while (arts.hasNext()) {
            workItems.add(this.atsApi.getWorkItemService().getWorkItem((ArtifactToken)arts.next()));
        }
        return workItems;
    }

    public boolean isDeleted(IAtsObject atsObject) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject)).isDeleted();
    }

    public boolean isAttributeTypeValid(IAtsObject atsObject, AttributeTypeToken attributeType) {
        return this.isAttributeTypeValid((ArtifactId)atsObject.getStoreObject(), attributeType);
    }

    public boolean isAttributeTypeValid(ArtifactId artifact, AttributeTypeToken attributeType) {
        return ((ArtifactReadable)artifact).isAttributeTypeValid((AttributeTypeId)attributeType);
    }

    public ArtifactTypeToken getArtifactType(ArtifactId artifact) {
        if (artifact instanceof ArtifactReadable) {
            return ((ArtifactReadable)artifact).getArtifactType();
        }
        return this.getQuery().andId(artifact).includeDeletedArtifacts().asArtifactToken().getArtifactType();
    }

    public ArtifactTypeToken getArtifactType(ArtifactId artifact, BranchId branch) {
        if (artifact instanceof ArtifactReadable) {
            return ((ArtifactReadable)artifact).getArtifactType();
        }
        return this.orcsApi.getQueryFactory().fromBranch(branch).andId(artifact).includeDeletedArtifacts().asArtifactToken().getArtifactType();
    }

    public void executeChangeSet(String comment, IAtsObject atsObject) {
        this.executeChangeSet(comment, Collections.singleton(atsObject));
    }

    public void executeChangeSet(String comment, Collection<? extends IAtsObject> atsObjects) {
        IAtsChangeSet changes = this.createAtsChangeSet(comment, this.atsApi.getUserService().getCurrentUser());
        for (IAtsObject iAtsObject : atsObjects) {
            changes.add((Object)iAtsObject);
        }
        changes.execute();
    }

    public Collection<AttributeTypeGeneric<?>> getAttributeTypes() {
        return this.orcsApi.tokenService().getAttributeTypes();
    }

    public boolean isChangedInDb(IAtsWorkItem workItem) {
        return false;
    }

    public ArtifactTypeToken getArtifactType(IAtsObject atsObject) {
        return this.getArtifactType((ArtifactId)this.atsApi.getQueryService().getArtifact((ArtifactId)atsObject.getStoreObject()));
    }

    public void clearCaches(IAtsWorkItem workItem) {
        ((WorkItem)workItem).clearCaches();
    }

    public Result setTransactionAssociatedArtifact(TransactionId trans, IAtsTeamWorkflow teamWf) {
        this.orcsApi.getTransactionFactory().setTransactionCommitArtifact(trans, (ArtifactId)teamWf.getStoreObject());
        return Result.TrueResult;
    }

    public TransactionId getTransactionId(IAtsWorkItem workItem) {
        TransactionId transId = TransactionId.SENTINEL;
        ArtifactToken artifact = this.atsApi.getQueryService().getArtifact(workItem.getId());
        if (artifact instanceof ArtifactReadable) {
            transId = ((ArtifactReadable)artifact).getTransaction();
        }
        return transId;
    }

    public boolean isDeleted(ArtifactId artifact) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact)).isDeleted();
    }

    public CustomizeData getCustomizationByGuid(String customize_guid) {
        CustomizeData cust = null;
        ArtifactReadable customizeStoreArt = (ArtifactReadable)this.getQuery().and((AttributeTypeId)CoreAttributeTypes.XViewerCustomization, customize_guid, QueryOption.CONTAINS_MATCH_OPTIONS).getResults().getAtMostOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (customizeStoreArt.isValid()) {
            for (String custXml : this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)customizeStoreArt, (AttributeTypeToken)CoreAttributeTypes.XViewerCustomization)) {
                if (!custXml.contains(customize_guid)) continue;
                cust = new CustomizeData(custXml);
                break;
            }
        }
        return cust;
    }

    public boolean isProductionDb() {
        return this.jdbcService.getClient().getConfig().isProduction();
    }

    public boolean isHistorical(IAtsObject atsObject) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(atsObject)).isHistorical();
    }

    public boolean isHistorical(ArtifactId artifact) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact)).isHistorical();
    }

    public boolean isReadOnly(IAtsWorkItem workItem) {
        throw new UnsupportedOperationException("unsupported on server");
    }

    public boolean isAccessControlWrite(IAtsWorkItem workItem) {
        return this.orcsApi.getAccessControlService().hasArtifactPermission(workItem.getStoreObject(), PermissionEnum.WRITE, null).isSuccess();
    }

    public void reloadArts(Collection<ArtifactToken> artifacts) {
    }

    public boolean isIdeClient() {
        return false;
    }

    public Collection<ArtifactToken> getDescendants(ArtifactToken art) {
        throw new UnsupportedOperationException("unsupported on server");
    }

    public String getSafeName(ArtifactId art) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(art)).getSafeName();
    }

    public boolean isOfType(ArtifactId artifact, ArtifactTypeToken artType) {
        return ((ArtifactReadable)this.atsApi.getQueryService().getArtifact(artifact)).isOfType(new ArtifactTypeId[]{artType});
    }

    public boolean isChangedInDb(ArtifactId workItem) {
        return false;
    }
}

