/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfaceElementArrayApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.InterfaceStructureApi;
import org.eclipse.osee.mim.InterfaceStructureFilterEndpoint;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.InterfaceStructureToken;
import org.eclipse.osee.mim.types.PlatformTypeToken;

public class InterfaceStructureFilterEndpointImpl
implements InterfaceStructureFilterEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId messageId;
    private final ArtifactId subMessageId;
    private final InterfaceStructureApi interfaceStructureApi;
    private final InterfaceElementApi interfaceElementApi;
    private final InterfaceElementArrayApi interfaceElementArrayApi;
    private final InterfacePlatformTypeApi platformApi;

    public InterfaceStructureFilterEndpointImpl(BranchId branch, UserId account, ArtifactId messageId, ArtifactId subMessageId, InterfaceStructureApi interfaceStructureApi, InterfaceElementApi interfaceElementApi, InterfaceElementArrayApi interfaceElementArrayApi, InterfacePlatformTypeApi interfacePlatformTypeApi) {
        this.account = account;
        this.branch = branch;
        this.messageId = messageId;
        this.subMessageId = subMessageId;
        this.interfaceStructureApi = interfaceStructureApi;
        this.interfaceElementApi = interfaceElementApi;
        this.interfaceElementArrayApi = interfaceElementArrayApi;
        this.platformApi = interfacePlatformTypeApi;
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures() {
        try {
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                double beginWord = 0.0;
                double endWord = 0.0;
                double beginWordDisplay = 0.0;
                double endWordDisplay = 0.0;
                double beginByte = 0.0;
                double endByte = 0.0;
                double beginByteDisplay = 0.0;
                double endByteDisplay = 0.0;
                double sizeInBytes = 0.0;
                LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
                elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
                for (InterfaceStructureElementToken element : elements) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    sizeInBytes += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart());
                    endByte = beginByte + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) % 4.0;
                    endWord = beginWord + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    beginByteDisplay = Math.floor(beginByte);
                    endByteDisplay = Math.floor(endByte);
                    element.setBeginByte(beginByteDisplay);
                    element.setEndByte(endByteDisplay);
                    beginByte = (endByte + 1.0) % 4.0;
                    beginWordDisplay = Math.floor(beginWord);
                    endWordDisplay = Math.floor(endWord);
                    element.setBeginWord(beginWordDisplay);
                    element.setEndWord(endWordDisplay);
                    beginWord += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                }
                structure.setSizeInBytes(sizeInBytes);
                structure.setElements(elements);
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    private List<AttributeTypeId> createStructureAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceStructureCategory);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMinSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMaxSimultaneity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceTaskFileType);
        return attributes;
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        return attributes;
    }

    @Override
    public Collection<InterfaceStructureToken> getStructures(String filter) {
        List<AttributeTypeId> structureAttributes = this.createStructureAttributeList();
        List<AttributeTypeId> elementAttributes = this.createElementAttributeList();
        try {
            List totalStructureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : totalStructureList) {
                double beginWord = 0.0;
                double endWord = 0.0;
                double beginWordDisplay = 0.0;
                double endWordDisplay = 0.0;
                double beginByte = 0.0;
                double endByte = 0.0;
                double beginByteDisplay = 0.0;
                double endByteDisplay = 0.0;
                double sizeInBytes = 0.0;
                LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
                elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
                for (InterfaceStructureElementToken element : elements) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    sizeInBytes += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart());
                    endByte = beginByte + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) % 4.0;
                    endWord = beginWord + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    beginByteDisplay = Math.floor(beginByte);
                    endByteDisplay = Math.floor(endByte);
                    element.setBeginByte(beginByteDisplay);
                    element.setEndByte(endByteDisplay);
                    beginByte = (endByte + 1.0) % 4.0;
                    beginWordDisplay = Math.floor(beginWord);
                    endWordDisplay = Math.floor(endWord);
                    element.setBeginWord(beginWordDisplay);
                    element.setEndWord(endWordDisplay);
                    beginWord += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                }
                structure.setSizeInBytes(sizeInBytes);
                structure.setElements(elements);
            }
            List structureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, this.subMessageId, filter, structureAttributes, InterfaceStructureToken.class);
            for (InterfaceStructureToken structure : structureList) {
                double beginWord = 0.0;
                double endWord = 0.0;
                double beginWordDisplay = 0.0;
                double endWordDisplay = 0.0;
                double beginByte = 0.0;
                double endByte = 0.0;
                double beginByteDisplay = 0.0;
                double endByteDisplay = 0.0;
                double sizeInBytes = 0.0;
                LinkedList<InterfaceStructureElementToken> elements = new LinkedList<InterfaceStructureElementToken>();
                elements.addAll(this.interfaceElementApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_Structure, ArtifactId.valueOf((Long)structure.getId()), InterfaceStructureElementToken.class));
                for (InterfaceStructureElementToken element : elements) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    sizeInBytes += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart());
                    endByte = beginByte + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) % 4.0;
                    endWord = beginWord + (Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 - 1.0) * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    beginByteDisplay = Math.floor(beginByte);
                    endByteDisplay = Math.floor(endByte);
                    element.setBeginByte(beginByteDisplay);
                    element.setEndByte(endByteDisplay);
                    beginByte = (endByte + 1.0) % 4.0;
                    beginWordDisplay = Math.floor(beginWord);
                    endWordDisplay = Math.floor(endWord);
                    element.setBeginWord(beginWordDisplay);
                    element.setEndWord(endWordDisplay);
                    beginWord += Double.parseDouble(platformType.getInterfacePlatformTypeBitSize()) / 8.0 * (double)Math.max(1, element.getInterfaceElementIndexEnd() - element.getInterfaceElementIndexStart()) / 4.0;
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                }
                structure.setSizeInBytes(sizeInBytes);
                structure.setElements(elements);
            }
            List elements = (List)this.interfaceElementApi.getAccessor().getAllByFilter(this.branch, filter, elementAttributes, InterfaceStructureElementToken.class);
            for (InterfaceStructureElementToken element : elements) {
                List subStructureList = (List)this.interfaceStructureApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceStructureContent_DataElement, ArtifactId.valueOf((Long)element.getId()), InterfaceStructureToken.class);
                for (InterfaceStructureToken alternateStructure : subStructureList) {
                    PlatformTypeToken platformType = this.platformApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceElementPlatformType_Element, ArtifactId.valueOf((Long)element.getId()), PlatformTypeToken.class);
                    element.setPlatformTypeId(platformType.getId());
                    element.setPlatformTypeName(platformType.getName());
                    if (totalStructureList.indexOf((Object)alternateStructure) != -1 && ((InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)))).getElements().indexOf((Object)element) != -1) {
                        InterfaceStructureElementToken tempElement = ((InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)))).getElements().get(((InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)))).getElements().indexOf((Object)element));
                        element.setBeginByte(tempElement.getBeginByte());
                        element.setEndByte(tempElement.getEndByte());
                        element.setBeginWord(tempElement.getBeginWord());
                        element.setEndWord(tempElement.getEndWord());
                    }
                    LinkedList<InterfaceStructureElementToken> elementList = new LinkedList<InterfaceStructureElementToken>();
                    elementList.add(element);
                    alternateStructure.setElements(elementList);
                    if (totalStructureList.indexOf((Object)alternateStructure) == -1) continue;
                    InterfaceStructureToken tempStructure = (InterfaceStructureToken)((Object)totalStructureList.get(totalStructureList.indexOf((Object)alternateStructure)));
                    alternateStructure.setSizeInBytes(tempStructure.getSizeInBytes());
                    if (!structureList.contains((Object)alternateStructure)) {
                        structureList.add(alternateStructure);
                        continue;
                    }
                    InterfaceStructureToken tempStructure2 = (InterfaceStructureToken)((Object)structureList.get(structureList.indexOf((Object)alternateStructure)));
                    structureList.remove((Object)alternateStructure);
                    tempStructure2.getElements().add(element);
                    structureList.add(tempStructure2);
                }
            }
            return structureList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

