/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.mim.InterfaceConnectionViewApi;
import org.eclipse.osee.mim.InterfaceNodeEndpoint;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.types.InterfaceNode;

public class InterfaceNodeEndpointImpl
implements InterfaceNodeEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final InterfaceNodeViewApi interfaceNodeApi;
    private final InterfaceConnectionViewApi interfaceConnectionApi;

    public InterfaceNodeEndpointImpl(BranchId branch, UserId account, InterfaceNodeViewApi interfaceNodeApi, InterfaceConnectionViewApi interfaceConnectionViewApi) {
        this.account = account;
        this.branch = branch;
        this.interfaceNodeApi = interfaceNodeApi;
        this.interfaceConnectionApi = interfaceConnectionViewApi;
    }

    @Override
    public Collection<InterfaceNode> getAllNodes() {
        try {
            return this.interfaceNodeApi.getAccessor().getAll(this.branch, InterfaceNode.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    @Override
    public InterfaceNode getNode(ArtifactId nodeId) {
        try {
            return this.interfaceNodeApi.getAccessor().get(this.branch, nodeId, InterfaceNode.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

