/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.transform;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.text.Rule;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;

public class DbSchemaRuleAddColumn
extends Rule {
    private static final Pattern tablePattern = Pattern.compile("\\s+<table name=\"([^\"]+)\"(.*?)</table>", 32);
    private final HashCollection<String, String> tableToColumns;

    public DbSchemaRuleAddColumn(HashCollection<String, String> tableToColumns) {
        super(null);
        this.tableToColumns = tableToColumns;
    }

    public DbSchemaRuleAddColumn(String tableName, String column) {
        this(DbSchemaRuleAddColumn.wrap(tableName, column));
    }

    private static HashCollection<String, String> wrap(String tableName, String column) {
        HashCollection tableToColumns = new HashCollection();
        tableToColumns.put((Object)tableName, (Object)column);
        return tableToColumns;
    }

    public ChangeSet computeChanges(CharSequence seq) {
        ChangeSet changeSet = new ChangeSet(seq);
        Matcher tableMatcher = tablePattern.matcher(seq);
        while (tableMatcher.find()) {
            Collection columns = this.tableToColumns.getValues((Object)tableMatcher.group(1));
            if (columns == null) continue;
            for (String column : columns) {
                if (tableMatcher.group(2).contains(column)) continue;
                changeSet.insertBefore(tableMatcher.end(2), column);
                this.ruleWasApplicable = true;
            }
        }
        return changeSet;
    }
}

