/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.authentication.ldap.internal;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.login.AccountException;
import org.eclipse.osee.authentication.ldap.LdapAuthenticationType;
import org.eclipse.osee.authentication.ldap.LdapSearchScope;
import org.eclipse.osee.authentication.ldap.internal.ContextConfigProvider;
import org.eclipse.osee.authentication.ldap.internal.LdapAccount;
import org.eclipse.osee.authentication.ldap.internal.LdapFilter;
import org.eclipse.osee.authentication.ldap.internal.LdapGroup;
import org.eclipse.osee.authentication.ldap.internal.filter.ActiveDirectoryLdapFilter;
import org.eclipse.osee.authentication.ldap.internal.filter.Rfc2307CompliantLdapFilter;
import org.eclipse.osee.authentication.ldap.internal.util.LdapEntry;
import org.eclipse.osee.authentication.ldap.internal.util.LdapQuery;
import org.eclipse.osee.authentication.ldap.internal.util.LdapUtil;
import org.eclipse.osee.authentication.ldap.internal.util.VariablePattern;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.logger.Log;

public class LdapConnection
implements Closeable {
    private static final LdapFilter RFC_2307_LDAP_FILTER = new Rfc2307CompliantLdapFilter();
    private static final LdapFilter ACTIVE_DIRECTORY_LDAP_FILTER = new ActiveDirectoryLdapFilter();
    private static final String LDAP_CAPABILITIES__ATTRIBUTE_ID = "supportedCapabilities";
    private static final String LDAP_CAPABILITIES__ACTIVE_DIRECTORY_OID = "1.2.840.113556.1.4.800";
    private static final String LDAP_CAPABILITIES__ACTIVE_DIRECTORY_APPLICATION_MODE_OID = "1.2.840.113556.1.4.1851";
    private final Log logger;
    private final DirContext connection;
    private final ContextConfigProvider provider;
    private LdapFilter defaultFilterSettings;

    public LdapConnection(Log logger, ContextConfigProvider provider, DirContext connection) {
        this.logger = logger;
        this.provider = provider;
        this.connection = connection;
    }

    private String getServerAddress() {
        return this.provider.getServerAddress();
    }

    @Override
    public void close() {
        this.close(this.connection);
    }

    public LdapFilter getDefaultFilter() {
        if (this.defaultFilterSettings == null) {
            boolean isActiveDirectory = false;
            try {
                isActiveDirectory = this.hasActiveDirectoryCapabilities();
            }
            catch (NamingException ex) {
                this.logger.warn((Throwable)ex, "Unable to determine LDAP server capabilities for [%s] defaulting to RFC-2307 compliant LDAP.", new Object[]{this.getServerAddress()});
            }
            this.defaultFilterSettings = isActiveDirectory ? ACTIVE_DIRECTORY_LDAP_FILTER : RFC_2307_LDAP_FILTER;
        }
        return this.defaultFilterSettings;
    }

    private boolean hasActiveDirectoryCapabilities() throws NamingException {
        Attributes rootAtts = this.connection.getAttributes("");
        Attribute attribute = rootAtts.get(LDAP_CAPABILITIES__ATTRIBUTE_ID);
        return attribute != null && (attribute.contains(LDAP_CAPABILITIES__ACTIVE_DIRECTORY_OID) || attribute.contains(LDAP_CAPABILITIES__ACTIVE_DIRECTORY_APPLICATION_MODE_OID));
    }

    public boolean authenticate(String username, String password) throws AccountException {
        Hashtable<String, String> env = this.provider.getContextConfig();
        env.put("java.naming.security.authentication", LdapAuthenticationType.SIMPLE.getContextAuthenticationName());
        env.put("java.naming.security.principal", LdapUtil.getValue(username, ""));
        env.put("java.naming.security.credentials", LdapUtil.getValue(password, ""));
        boolean result = false;
        InitialDirContext connection = null;
        try {
            try {
                connection = new InitialDirContext(env);
                result = true;
            }
            catch (NamingException namingException) {
                throw new AccountException("Incorrect userName or password");
            }
        }
        catch (Throwable throwable) {
            this.close(connection);
            throw throwable;
        }
        this.close(connection);
        return result;
    }

    private void close(DirContext connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (NamingException ex) {
                this.logger.error((Throwable)ex, "Error closing LDAP connected to [%s]", new Object[]{this.getServerAddress()});
            }
        }
    }

    public LdapAccount findAccount(LdapFilter filter, String username) throws NamingException {
        VariablePattern groupByGroupMemberPattern;
        boolean memberOfFieldInAccount;
        LdapFilter defaultFilter = this.getDefaultFilter();
        String usernameVariableName = LdapUtil.getValue(filter.getUserNameVariableName(), defaultFilter.getUserNameVariableName());
        String searchBase = LdapUtil.getValue(filter.getAccountBase(), defaultFilter.getAccountBase());
        LdapSearchScope accountSearchScope = LdapUtil.getValue(filter.getAccountSearchScope(), defaultFilter.getAccountSearchScope());
        HashSet<String> fieldsToGet = new HashSet<String>();
        VariablePattern accountSearchPattern = LdapUtil.patternField(fieldsToGet, filter.getAccountPattern(), defaultFilter.getAccountPattern());
        VariablePattern accountFullName = LdapUtil.patternField(fieldsToGet, filter.getAccountDisplayName(), defaultFilter.getAccountDisplayName());
        VariablePattern accountEmailAddress = LdapUtil.patternField(fieldsToGet, filter.getAccountEmailAddress(), defaultFilter.getAccountEmailAddress());
        VariablePattern accountUserName = LdapUtil.patternField(fieldsToGet, filter.getAccountUserName(), defaultFilter.getAccountUserName());
        String memberOfField = LdapUtil.stringField(fieldsToGet, filter.getGroupMembersOf(), defaultFilter.getGroupMembersOf());
        boolean bl = memberOfFieldInAccount = Strings.isValid((String)memberOfField) || defaultFilter.isGroupMembershipPartOfAccount();
        if (memberOfFieldInAccount && (groupByGroupMemberPattern = LdapUtil.patternField(fieldsToGet, filter.getGroupByGroupMemberPattern(), defaultFilter.getGroupByGroupMemberPattern())) != null) {
            for (String variables : groupByGroupMemberPattern.getVariableNames()) {
                fieldsToGet.add(variables);
            }
        }
        LdapQuery query = new LdapQuery(this.logger).base(searchBase).pattern(accountSearchPattern).fields(fieldsToGet).scope(accountSearchScope);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(usernameVariableName, username);
        ResultSet<LdapEntry> results = query.search(this.connection, params);
        LdapEntry entry = (LdapEntry)results.getExactlyOne();
        return new LdapAccount(entry, accountFullName, accountEmailAddress, accountUserName);
    }

    public Set<LdapGroup> findGroups(LdapFilter filter, String username) throws NamingException {
        return this.findGroups(filter, username, null);
    }

    public Set<LdapGroup> findGroups(LdapFilter filter, String username, LdapAccount account) throws NamingException {
        boolean isGroupMembershipInAccount;
        LdapFilter defaultFilter = this.getDefaultFilter();
        String usernameVariableName = LdapUtil.getValue(filter.getUserNameVariableName(), defaultFilter.getUserNameVariableName());
        String searchBase = LdapUtil.getValue(filter.getGroupBase(), defaultFilter.getGroupBase());
        LdapSearchScope groupSearchScope = LdapUtil.getValue(filter.getGroupSearchScope(), defaultFilter.getGroupSearchScope());
        HashSet<String> fieldsToGet = new HashSet<String>();
        VariablePattern groupNamePattern = LdapUtil.patternField(fieldsToGet, filter.getGroupName(), defaultFilter.getGroupName());
        VariablePattern groupByGroupMemberPattern = LdapUtil.patternField(fieldsToGet, filter.getGroupByGroupMemberPattern(), defaultFilter.getGroupByGroupMemberPattern());
        String memberOfField = LdapUtil.getValue(filter.getGroupMembersOf(), defaultFilter.getGroupMembersOf());
        boolean bl = isGroupMembershipInAccount = groupByGroupMemberPattern == null || defaultFilter.isGroupMembershipPartOfAccount();
        if (isGroupMembershipInAccount) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        LdapQuery query = new LdapQuery(this.logger).base(searchBase).pattern(groupByGroupMemberPattern).fields(fieldsToGet).scope(groupSearchScope);
        HashMap<String, String> params = new HashMap<String, String>();
        for (String key : query.getParameters()) {
            String value = account.getField(key);
            if (!Strings.isValid((String)value)) continue;
            params.put(key, value);
        }
        params.put(usernameVariableName, username);
        ResultSet<LdapEntry> results = query.search(this.connection, params);
        HashSet<LdapGroup> groups = new HashSet<LdapGroup>();
        HashSet<String> groupDns = new HashSet<String>();
        for (LdapEntry entry : results) {
            this.findSubGroups(groups, groupDns, groupNamePattern, memberOfField, entry);
        }
        return groups;
    }

    private void findSubGroups(Set<LdapGroup> groups, Set<String> groupDns, VariablePattern groupNamePattern, String memberOfField, LdapEntry entry) throws NamingException {
        String currentGroupDn = entry.getDistinguishedName();
        boolean wasAdded = groupDns.add(currentGroupDn);
        if (wasAdded) {
            LdapGroup group = new LdapGroup(entry, groupNamePattern);
            groups.add(group);
            if (Strings.isValid((String)memberOfField)) {
                throw new UnsupportedOperationException("Not yet implemented");
            }
        }
    }
}

