/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.AbstractSourceTagger;
import org.eclipse.osee.define.ide.traceability.CodeUnitTagger;
import org.eclipse.osee.define.ide.traceability.HierarchyHandler;
import org.eclipse.osee.define.ide.traceability.TestUnitTagger;
import org.eclipse.osee.define.ide.traceability.TraceabilityExtractor;
import org.eclipse.osee.define.ide.traceability.data.CodeUnitData;
import org.eclipse.osee.define.ide.traceability.data.RequirementData;
import org.eclipse.osee.define.ide.traceability.data.TestUnitData;
import org.eclipse.osee.define.ide.traceability.data.TraceMark;
import org.eclipse.osee.define.ide.traceability.data.TraceUnit;
import org.eclipse.osee.define.ide.traceability.operations.ITraceUnitProcessor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.html.ResultsEditorHtmlTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;

public class TraceUnitToArtifactProcessor
implements ITraceUnitProcessor {
    private RequirementData requirementData;
    private CodeUnitData codeUnitData;
    private TestUnitData testUnitData;
    private final boolean addGuidToSourceFile;
    private final BranchId importIntoBranch;
    private SkynetTransaction transaction;
    private HierarchyHandler handler;
    private final HashCollectionSet<TraceUnit, TraceMark> reportTraceNotFound;
    private final HashCollectionSet<String, String> unknownRelationError;
    private final Set<String> unRelatedUnits;

    public TraceUnitToArtifactProcessor(BranchId importIntoBranch, boolean addGuidToSourceFile) {
        this.importIntoBranch = importIntoBranch;
        this.reportTraceNotFound = new HashCollectionSet(HashSet::new);
        this.unknownRelationError = new HashCollectionSet(HashSet::new);
        this.unRelatedUnits = new HashSet<String>();
        this.addGuidToSourceFile = addGuidToSourceFile;
    }

    @Override
    public void clear() {
        this.transaction = null;
        this.handler = null;
        if (this.requirementData != null) {
            this.requirementData.reset();
            this.requirementData = null;
        }
        if (this.testUnitData != null) {
            this.testUnitData.reset();
            this.testUnitData = null;
        }
        if (this.codeUnitData != null) {
            this.codeUnitData.reset();
            this.codeUnitData = null;
        }
    }

    @Override
    public void initialize(IProgressMonitor monitor) {
        this.transaction = null;
        this.handler = null;
        this.requirementData = new RequirementData(this.importIntoBranch, ArtifactId.SENTINEL);
        if (!monitor.isCanceled()) {
            this.requirementData.initialize(monitor);
        }
    }

    private Artifact getArtifactFromCache(IProgressMonitor monitor, ArtifactTypeToken artifactType, String name) {
        if (artifactType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.TestUnit)) {
            if (this.testUnitData == null) {
                this.testUnitData = new TestUnitData(this.importIntoBranch);
                if (!monitor.isCanceled()) {
                    this.testUnitData.initialize(monitor);
                }
            }
            return this.testUnitData.getTestUnitByName(name);
        }
        if (artifactType.inheritsFrom((ArtifactTypeId)CoreArtifactTypes.CodeUnit)) {
            if (this.codeUnitData == null) {
                this.codeUnitData = new CodeUnitData(this.importIntoBranch);
                if (!monitor.isCanceled()) {
                    this.codeUnitData.initialize(monitor);
                }
            }
            return this.codeUnitData.getCodeUnitByName(name);
        }
        return null;
    }

    private AbstractSourceTagger getGuidUtility(ArtifactTypeToken artifactType) {
        if (artifactType.equals(CoreArtifactTypes.TestCase)) {
            return TestUnitTagger.getInstance();
        }
        if (artifactType.equals(CoreArtifactTypes.CodeUnit)) {
            return CodeUnitTagger.getInstance();
        }
        return null;
    }

    @Override
    public void process(IProgressMonitor monitor, TraceUnit traceUnit) {
        if (this.transaction == null) {
            this.transaction = TransactionManager.createTransaction((BranchId)this.importIntoBranch, (String)"Importing Trace Unit(s)");
            this.handler = new HierarchyHandler(this.transaction);
        }
        boolean hasChange = false;
        boolean artifactWasCreated = false;
        boolean wasRelated = false;
        Artifact traceUnitArtifact = null;
        AbstractSourceTagger guidUtility = this.getGuidUtility(traceUnit.getTraceUnitType());
        String guid = null;
        if (guidUtility != null) {
            URI uriPath = traceUnit.getUriPath();
            if (uriPath != null) {
                try {
                    guid = guidUtility.getSourceTag(uriPath);
                }
                catch (IOException ex) {
                    OseeCoreException.wrapAndThrow((Throwable)ex);
                }
            }
            if (guid != null) {
                if (!GUID.isValid(guid) && this.addGuidToSourceFile) {
                    try {
                        guidUtility.removeSourceTag(uriPath);
                    }
                    catch (IOException ex) {
                        OseeCoreException.wrapAndThrow((Throwable)ex);
                    }
                } else {
                    traceUnitArtifact = ArtifactQuery.checkArtifactFromId((String)guid, (BranchId)this.transaction.getBranch(), (DeletionFlag)DeletionFlag.INCLUDE_DELETED);
                    if (traceUnitArtifact != null && traceUnitArtifact.isDeleted()) {
                        traceUnitArtifact = null;
                        guid = null;
                    }
                }
            }
        }
        if (traceUnitArtifact == null) {
            traceUnitArtifact = this.getArtifactFromCache(monitor, traceUnit.getTraceUnitType(), traceUnit.getName());
        }
        if (traceUnitArtifact == null) {
            BranchToken branch = BranchManager.getBranchToken((BranchId)this.transaction.getBranch());
            traceUnitArtifact = ArtifactTypeManager.addArtifact((ArtifactTypeToken)traceUnit.getTraceUnitType(), (BranchToken)branch, null, (String)guid);
            traceUnitArtifact.setName(traceUnit.getName());
            artifactWasCreated = true;
        }
        if (guidUtility != null && !traceUnitArtifact.getGuid().equals(guid) && this.addGuidToSourceFile) {
            try {
                guidUtility.removeSourceTag(traceUnit.getUriPath());
                guidUtility.addSourceTag(traceUnit.getUriPath(), traceUnitArtifact.getGuid());
            }
            catch (IOException ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        if (!traceUnitArtifact.getName().equals(traceUnit.getName())) {
            traceUnitArtifact.setName(traceUnit.getName());
            hasChange = true;
        }
        this.removeExistingTraceability(traceUnitArtifact);
        for (TraceMark traceMark : traceUnit.getTraceMarks()) {
            if (monitor.isCanceled()) break;
            Artifact requirementArtifact = this.getRequirementArtifact(traceMark.getRawTraceMark(), this.requirementData);
            if (requirementArtifact != null) {
                RelationTypeSide relationType = this.getRelationFromTraceType(traceUnitArtifact, traceMark.getTraceType());
                if (relationType == null) {
                    this.unknownRelationError.put((Object)traceUnitArtifact.getArtifactTypeName(), (Object)traceMark.getTraceType());
                    continue;
                }
                if (!requirementArtifact.isRelated(relationType, traceUnitArtifact)) {
                    requirementArtifact.addRelation(relationType, traceUnitArtifact);
                    hasChange = true;
                    wasRelated = true;
                    continue;
                }
                wasRelated = true;
                continue;
            }
            this.reportTraceNotFound.put((Object)traceUnit, (Object)traceMark);
        }
        if (!wasRelated) {
            this.unRelatedUnits.add(traceUnitArtifact.getName());
        }
        if (hasChange || artifactWasCreated) {
            this.handler.addArtifact(traceUnitArtifact);
            traceUnitArtifact.persist(this.transaction);
        }
    }

    private boolean isUsesTraceType(String traceType) {
        return traceType.equalsIgnoreCase("USES");
    }

    private RelationTypeSide getRelationFromTraceType(Artifact traceUnitArtifact, String traceType) {
        if (traceUnitArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.TestUnit})) {
            if (this.isUsesTraceType(traceType)) {
                return CoreRelationTypes.Uses_TestUnit;
            }
            return CoreRelationTypes.Verification_Verifier;
        }
        if (traceUnitArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.CodeUnit})) {
            return CoreRelationTypes.CodeRequirement_CodeUnit;
        }
        return null;
    }

    private void removeExistingTraceability(Artifact traceUnitArtifact) {
        if (traceUnitArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.TestUnit})) {
            traceUnitArtifact.deleteRelations(CoreRelationTypes.Uses_Requirement);
            traceUnitArtifact.deleteRelations(CoreRelationTypes.Verification_Requirement);
        } else if (traceUnitArtifact.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.CodeUnit})) {
            traceUnitArtifact.deleteRelations(CoreRelationTypes.CodeRequirement_Requirement);
        }
    }

    private Artifact getRequirementArtifact(String traceMark, RequirementData requirementData) {
        Pair<String, String> structuredRequirement;
        Artifact toReturn = requirementData.getRequirementFromTraceMark(traceMark);
        if (toReturn == null && (structuredRequirement = TraceabilityExtractor.getInstance().getStructuredRequirement(traceMark)) != null) {
            toReturn = requirementData.getRequirementFromTraceMark((String)structuredRequirement.getFirst());
        }
        return toReturn;
    }

    @Override
    public void onComplete(IProgressMonitor monitor) {
        try {
            if (!monitor.isCanceled() && this.transaction != null) {
                this.transaction.execute();
            }
        }
        finally {
            this.openReport();
        }
    }

    private void openReport() {
        IExceptionableRunnable runnable = new IExceptionableRunnable(){

            public IStatus run(IProgressMonitor monitor) throws Exception {
                ResultsEditor.open((IResultsEditorProvider)new ResultEditorProvider());
                return Status.OK_STATUS;
            }
        };
        Jobs.runInJob((String)"Trace Unit to Artifact Report", (IExceptionableRunnable)runnable, Activator.class, (String)"org.eclipse.osee.define.ide");
    }

    private final class ResultEditorProvider
    implements IResultsEditorProvider {
        private ResultEditorProvider() {
        }

        public String getEditorName() {
            return "Trace Units To Artifacts Report";
        }

        private List<XViewerColumn> createColumns(String ... columnNames) {
            ArrayList<XViewerColumn> columns = new ArrayList<XViewerColumn>();
            String[] stringArray = columnNames;
            int n = columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                columns.add(new XViewerColumn(name, name, 80, XViewerAlign.Left, true, SortDataType.String, false, ""));
                ++n2;
            }
            return columns;
        }

        private void addUnRelatedTraceUnit(List<IResultsEditorTab> toReturn) {
            if (!TraceUnitToArtifactProcessor.this.unRelatedUnits.isEmpty()) {
                List<XViewerColumn> columns = this.createColumns("Trace Unit Name");
                ArrayList<ResultsXViewerRow> rows = new ArrayList<ResultsXViewerRow>();
                for (String artifactName : TraceUnitToArtifactProcessor.this.unRelatedUnits) {
                    rows.add(new ResultsXViewerRow(new String[]{artifactName}));
                }
                toReturn.add((IResultsEditorTab)new ResultsEditorTableTab("Trace Units Created But Had No Relations", columns, rows));
            }
        }

        private void addTraceNotFoundTab(List<IResultsEditorTab> toReturn) {
            if (!TraceUnitToArtifactProcessor.this.reportTraceNotFound.isEmpty()) {
                List<XViewerColumn> columns = this.createColumns("Trace Unit Name", "Trace Unit Type", "Trace Mark Type", "Trace Mark");
                ArrayList<ResultsXViewerRow> rows = new ArrayList<ResultsXViewerRow>();
                for (TraceUnit unit : TraceUnitToArtifactProcessor.this.reportTraceNotFound.keySet()) {
                    Collection traceMarks = TraceUnitToArtifactProcessor.this.reportTraceNotFound.getValues((Object)unit);
                    for (TraceMark traceMark : traceMarks) {
                        rows.add(new ResultsXViewerRow(new String[]{unit.getName(), unit.getTraceUnitType().getName(), traceMark.getTraceType(), traceMark.getRawTraceMark()}));
                    }
                }
                toReturn.add((IResultsEditorTab)new ResultsEditorTableTab("Trace Marks Not Found", columns, rows));
            }
        }

        private void addRelationTypeNotFoundTab(List<IResultsEditorTab> toReturn) {
            if (!TraceUnitToArtifactProcessor.this.unknownRelationError.isEmpty()) {
                List<XViewerColumn> columns = this.createColumns("Artifact Type", "Trace Mark Type");
                ArrayList<ResultsXViewerRow> rows = new ArrayList<ResultsXViewerRow>();
                for (String artifactType : TraceUnitToArtifactProcessor.this.unknownRelationError.keySet()) {
                    Collection traceTypes = TraceUnitToArtifactProcessor.this.unknownRelationError.getValues((Object)artifactType);
                    for (String traceType : traceTypes) {
                        rows.add(new ResultsXViewerRow(new String[]{artifactType, traceType}));
                    }
                }
                toReturn.add((IResultsEditorTab)new ResultsEditorTableTab("Invalid Artifact Type to Trace Relation", columns, rows));
            }
        }

        public List<IResultsEditorTab> getResultsEditorTabs() {
            ArrayList<IResultsEditorTab> toReturn = new ArrayList<IResultsEditorTab>();
            this.addTraceNotFoundTab(toReturn);
            this.addUnRelatedTraceUnit(toReturn);
            this.addRelationTypeNotFoundTab(toReturn);
            if (toReturn.isEmpty()) {
                toReturn.add((IResultsEditorTab)new ResultsEditorHtmlTab("Trace Unit Import Status", "Import Status", "All Items Linked"));
            }
            return toReturn;
        }
    }
}

