/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoCscis;
import org.eclipse.osee.ats.api.team.ChangeType;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.INewActionListener;
import org.eclipse.osee.ats.api.workflow.transition.TransitionOption;
import org.eclipse.osee.ats.core.workflow.transition.TeamWorkFlowManager;
import org.eclipse.osee.ats.ide.demo.config.DemoDbUtil;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.demo.populate.IPopulateDemoDatabase;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoSubsystems;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class Pdd20CreateCommittedAction
implements IPopulateDemoDatabase {
    @Override
    public void run() {
        IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getClass().getSimpleName());
        Collection<IAtsActionableItem> aias = DemoDbUtil.getActionableItems(new ArtifactToken[]{DemoArtifactToken.SAW_Requirements_AI, DemoArtifactToken.SAW_Code_AI, DemoArtifactToken.SAW_Test_AI});
        Date createdDate = new Date();
        AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
        String priority = "1";
        ActionResult actionResult = AtsApiService.get().getActionService().createAction(null, "SAW (committed) Reqt Changes for Diagram View", "Problem with the Diagram View", ChangeType.Problem, priority, false, null, aias, createdDate, createdBy, Arrays.asList(new ArtifactTokenActionListener()), changes);
        for (IAtsTeamWorkflow teamWf : actionResult.getTeams()) {
            if (teamWf.getTeamDefinition().getName().contains("Req") && !teamWf.getWorkDefinition().getName().equals("WorkDef_Team_Demo_Req")) {
                throw new OseeCoreException("Req workflow expected work def [WorkDef_Team_Demo_Req] actual [%s]", new Object[]{teamWf.getWorkDefinition().getName()});
            }
            if (teamWf.getTeamDefinition().getName().contains("Code") && !teamWf.getWorkDefinition().getName().equals("WorkDef_Team_Demo_Code")) {
                throw new OseeCoreException("Code workflow expected work def [WorkDef_Team_Demo_Code] actual [%s]", new Object[]{teamWf.getWorkDefinition().getName()});
            }
            if (teamWf.getTeamDefinition().getName().contains("Test") && !teamWf.getWorkDefinition().getName().equals("WorkDef_Team_Demo_Test")) {
                throw new OseeCoreException("Test workflow expected work def [WorkDef_Team_Demo_Test] actual [%s]", new Object[]{teamWf.getWorkDefinition().getName()});
            }
            TeamWorkFlowManager dtwm = new TeamWorkFlowManager(teamWf, (AtsApi)AtsApiService.get(), new TransitionOption[]{TransitionOption.OverrideAssigneeCheck, TransitionOption.OverrideTransitionValidityCheck});
            Result result = dtwm.transitionTo(toState, (AtsUser)teamWf.getAssignees().iterator().next(), false, changes);
            if (result.isFalse()) {
                throw new OseeCoreException("Error transitioning [%s] to state [%s]: [%s]", new Object[]{teamWf.toStringWithId(), toState.getName(), result.getText()});
            }
            if (!teamWf.isCompletedOrCancelled()) {
                teamWf.getStateMgr().setAssignees(AtsApiService.get().getTeamDefinitionService().getLeads(teamWf.getTeamDefinition()));
            }
            changes.add((Object)teamWf);
            this.setVersion(teamWf, (ArtifactToken)DemoArtifactToken.SAW_Bld_2, changes);
        }
        changes.execute();
        TeamWorkFlowArtifact reqTeamArt = null;
        for (IAtsTeamWorkflow teamWf : actionResult.getTeams()) {
            if (!teamWf.getTeamDefinition().getName().contains("Req")) continue;
            reqTeamArt = (TeamWorkFlowArtifact)teamWf.getStoreObject();
        }
        if (reqTeamArt == null) {
            throw new OseeArgumentException("Can't locate Req team.", new Object[0]);
        }
        Result result = AtsApiService.get().getBranchServiceIde().createWorkingBranch_Validate(reqTeamArt);
        if (result.isFalse()) {
            throw new OseeArgumentException("Error creating working branch: " + result, new Object[0]);
        }
        AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)reqTeamArt, true);
        for (Artifact art : DemoDbUtil.getSoftwareRequirements(false, DemoDbUtil.SoftwareRequirementStrs.Robot, (BranchId)reqTeamArt.getWorkingBranch())) {
            art.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.CSCI, (Object)DemoCscis.Navigation.name());
            art.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Navigation.name());
            Artifact navArt = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Component, (String)DemoSubsystems.Navigation.name(), (BranchId)reqTeamArt.getWorkingBranch());
            art.addRelation(CoreRelationTypes.Allocation_Component, navArt);
            art.persist(this.getClass().getSimpleName());
        }
        Artifact testArtifact = null;
        Artifact testRelArtifact = null;
        for (Artifact art : DemoDbUtil.getSoftwareRequirements(false, DemoDbUtil.SoftwareRequirementStrs.Event, (BranchId)reqTeamArt.getWorkingBranch())) {
            art.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.CSCI, (Object)DemoCscis.Interface.name());
            art.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            Artifact robotArt = ArtifactQuery.getArtifactFromTypeAndName((ArtifactTypeId)CoreArtifactTypes.Component, (String)DemoSubsystems.Robot_API.name(), (BranchId)reqTeamArt.getWorkingBranch());
            art.addRelation(CoreRelationTypes.Allocation_Component, robotArt);
            art.persist(this.getClass().getSimpleName());
            testArtifact = art;
            testRelArtifact = robotArt;
        }
        for (Artifact art : DemoDbUtil.getSoftwareRequirements(false, DemoDbUtil.SoftwareRequirementStrs.daVinci, (BranchId)reqTeamArt.getWorkingBranch())) {
            art.deleteAndPersist(this.getClass().getSimpleName());
        }
        Artifact parentArt = DemoDbUtil.getInterfaceInitializationSoftwareRequirement(false, (BranchId)reqTeamArt.getWorkingBranch());
        int x = 1;
        while (x < 4) {
            String name = "Robot Interface Init " + x;
            Artifact newArt = ArtifactTypeManager.addArtifact((ArtifactTypeToken)CoreArtifactTypes.SoftwareRequirementMsWord, (BranchToken)parentArt.getBranch(), (String)name);
            newArt.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem, (Object)DemoSubsystems.Communications.name());
            newArt.persist(this.getClass().getSimpleName());
            parentArt.addChild(newArt);
            parentArt.persist(this.getClass().getSimpleName());
            ++x;
        }
        Artifact parentArtifact = this.testCommitBranchHttpRequestOperationSetup(reqTeamArt, testArtifact, testRelArtifact);
        XResultData rd = AtsApiService.get().getBranchServiceIde().commitWorkingBranch(reqTeamArt, false, true, AtsApiService.get().getBranchService().getBranch((IAtsConfigObject)AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)reqTeamArt)), true, new XResultData());
        if (rd.isErrors()) {
            throw new OseeCoreException(rd.toString(), new Object[0]);
        }
        this.testCommitBranchHttpRequestOperation(testRelArtifact, parentArtifact);
    }

    private void testCommitBranchHttpRequestOperation(Artifact testRelArtifact, Artifact parentArtifact) {
        int loops = 1;
        int x = 0;
        while (x <= loops) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            String subsystemStrAfter = parentArtifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem).toString();
            if (!subsystemStrAfter.equals(DemoSubsystems.Communications.name())) {
                if (x >= loops) {
                    throw new OseeArgumentException("Artifact Attribute did not update in Parent Branch after commit", new Object[0]);
                }
            } else {
                Boolean artFound = false;
                for (Artifact art : parentArtifact.getRelatedArtifacts(CoreRelationTypes.Allocation_Component)) {
                    if (art.getArtId() != testRelArtifact.getArtId()) continue;
                    artFound = true;
                }
                if (!artFound.booleanValue() && x >= loops) {
                    throw new OseeArgumentException("Artifact Relation does NOT exist in Parent branch after commit.", new Object[0]);
                }
            }
            ++x;
        }
    }

    private Artifact testCommitBranchHttpRequestOperationSetup(TeamWorkFlowArtifact reqTeamArt, Artifact testArtifact, Artifact testRelArtifact) {
        BranchId parentBranch = AtsApiService.get().getBranchService().getBranch((IAtsConfigObject)AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)reqTeamArt));
        Artifact parentArtifact = ArtifactQuery.getArtifactFromId((long)testArtifact.getId(), (BranchId)parentBranch);
        String subsystemStrBefore = parentArtifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Subsystem).toString();
        if (subsystemStrBefore.equals(DemoSubsystems.Communications.name())) {
            throw new OseeArgumentException("Artifact Attribute matches between Working and Parent branch before commit.  Invalid Test. ", new Object[0]);
        }
        for (Artifact art : parentArtifact.getRelatedArtifacts(CoreRelationTypes.Allocation_Component)) {
            if (art.getId() != testRelArtifact.getId()) continue;
            throw new OseeArgumentException("Artifact Relation exists in Working and Parent branch before commit.  Invalid Test. ", new Object[0]);
        }
        return parentArtifact;
    }

    private class ArtifactTokenActionListener
    implements INewActionListener {
        private ArtifactTokenActionListener() {
        }

        public ArtifactToken getArtifactToken(List<IAtsActionableItem> applicableAis) {
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Test_AI)) {
                return DemoArtifactToken.SAW_Commited_Test_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Code_AI)) {
                return DemoArtifactToken.SAW_Commited_Code_TeamWf;
            }
            if (applicableAis.iterator().next().equals(DemoArtifactToken.SAW_Requirements_AI)) {
                return DemoArtifactToken.SAW_Commited_Req_TeamWf;
            }
            throw new UnsupportedOperationException();
        }
    }
}

