/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.client.server;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.client.CoreClientConstants;
import org.eclipse.osee.framework.core.client.OseeClientProperties;
import org.eclipse.osee.framework.core.client.internal.Activator;
import org.eclipse.osee.framework.core.client.server.HttpServer;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.HttpUrlBuilder;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;

public final class HttpUrlBuilderClient {
    public static final String USE_CONNECTED_SERVER_URL_FOR_PERM_LINKS = String.valueOf(CoreClientConstants.getBundleId()) + "osee.use.connected.server.url.for.perm.links";
    private static final String urlPrefixFormat = "http://%s:%s/";
    private static final HttpUrlBuilderClient instance = new HttpUrlBuilderClient();

    private HttpUrlBuilderClient() {
    }

    public static HttpUrlBuilderClient getInstance() {
        return instance;
    }

    public boolean isUseConnectedServerUrl() {
        boolean isUseConnectedServerUrl = Activator.getInstance().getPluginPreferences().getBoolean(USE_CONNECTED_SERVER_URL_FOR_PERM_LINKS);
        return isUseConnectedServerUrl;
    }

    public String getUrlForLocalSkynetHttpServer(String context, Map<String, String> parameters) {
        try {
            return HttpUrlBuilder.createURL((String)this.getHttpLocalServerPrefix(), (String)context, parameters);
        }
        catch (UnsupportedEncodingException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return null;
        }
    }

    public String getHttpLocalServerPrefix() {
        int port = HttpServer.getDefaultServicePort();
        if (port == -1) {
            throw new OseeStateException("Http Server was not launched by this workbench - Ensure port was set correctly", new Object[0]);
        }
        return String.format(urlPrefixFormat, HttpServer.getLocalServerAddress(), port);
    }

    public String getApplicationServerPrefix() {
        String address = OseeClientProperties.getOseeApplicationServer();
        return HttpUrlBuilderClient.normalize(address);
    }

    private static String normalize(String address) {
        String toReturn = address;
        if (Strings.isValid((String)toReturn) && !toReturn.endsWith("/")) {
            toReturn = String.valueOf(toReturn) + "/";
        }
        return toReturn;
    }

    public String getOsgiServletServiceUrl(String context, Map<String, String> parameters) {
        String url = null;
        try {
            String applicationServerPrefix = this.getApplicationServerPrefix();
            if (Strings.isValid((String)applicationServerPrefix)) {
                url = HttpUrlBuilder.createURL((String)applicationServerPrefix, (String)context, parameters);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
        return url;
    }
}

