/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal;

import org.eclipse.osee.framework.messaging.ConnectionNode;
import org.eclipse.osee.framework.messaging.MessageService;
import org.eclipse.osee.framework.messaging.NodeInfo;
import org.eclipse.osee.framework.messaging.internal.ConsoleDebugSupport;
import org.eclipse.osee.framework.messaging.internal.ServiceUtility;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;

public class MessageServiceConsole
implements CommandProvider {
    private MessageService messageService;

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void _msgPrintSummary(CommandInterpreter ci) throws Exception {
        for (NodeInfo info : this.messageService.getAvailableConnections()) {
            ConnectionNode node = this.messageService.get(info);
            ci.println((Object)node.getSummary());
        }
    }

    public void _msgPrintSend(CommandInterpreter ci) throws Exception {
        ConsoleDebugSupport support = ServiceUtility.getConsoleDebugSupport();
        if (support != null) {
            support.setPrintSends(!support.getPrintSends());
            ci.println((Object)("printSends " + support.getPrintSends()));
        } else {
            ci.println((Object)"ConsoleDebugSupport service not found, unable to show sends.");
        }
    }

    public void _msgPrintReceive(CommandInterpreter ci) throws Exception {
        ConsoleDebugSupport support = ServiceUtility.getConsoleDebugSupport();
        if (support != null) {
            support.setPrintReceives(!support.getPrintReceives());
            ci.println((Object)("printReceives " + support.getPrintReceives()));
        } else {
            ci.println((Object)"ConsoleDebugSupport service not found, unable to show receives.");
        }
    }

    public void _msgPrintStats(CommandInterpreter ci) throws Exception {
        ConsoleDebugSupport support = ServiceUtility.getConsoleDebugSupport();
        if (support != null) {
            String arg = ci.nextArgument();
            if (arg == null) {
                support.printAllStats(ci);
            } else if (arg.equals("tx")) {
                support.printTxStats(ci);
            } else if (arg.equals("rx")) {
                support.printRxStats(ci);
            }
        } else {
            ci.println((Object)"ConsoleDebugSupport service not found, unable to show receives.");
        }
    }

    public String getHelp() {
        StringBuilder sb = new StringBuilder();
        sb.append("---Message Service Commands---\n");
        sb.append("\tmsgPrintSummary - prints a Summary of all ConnectionNodes.\n");
        sb.append("\tmsgPrintReceive - print out a receive when it happens to std.out.\n");
        sb.append("\tmsgPrintSend - print out a receive when it happens.to std.out.\n");
        sb.append("\tmsgPrintStats [tx|rx]- print out a stats collected on sends and/or receives.\n");
        return sb.toString();
    }
}

