/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class LatLongBox
extends Composite {
    private final Text degreesTxt;
    private final Text minutesTxt;
    private final Text secondsTxt;
    private Color background;
    private boolean hasFocus = false;
    private final boolean[] boxTabFlag = new boolean[3];
    private int maxDegrees = 360;
    private int minDegrees = -360;
    private Double dValue = null;

    public LatLongBox(Composite parent) {
        this(parent, 2048);
    }

    public LatLongBox(Composite parent, int style) {
        super(parent, style);
        this.setToolTipText("Enter degrees, minutes, and seconds");
        Widgets.setFormLayout(this, 0, 0);
        this.background = (style & 8) > 0 ? parent.getBackground() : this.getDisplay().getSystemColor(1);
        this.setBackground(this.background);
        int NO_BORDER_MASK = -2049;
        Label sep1 = new Label((Composite)this, 0x1000000);
        sep1.setText(String.format("%c", 176));
        sep1.setBackground(this.background);
        Widgets.attachToParent((Control)sep1, 16384, 33, 0);
        Widgets.attachToParent((Control)sep1, 128, 0, 3);
        Label sep2 = new Label((Composite)this, 0x1000000);
        sep2.setText("'");
        sep2.setBackground(this.background);
        Widgets.attachToParent((Control)sep2, 16384, 66, -2);
        Widgets.attachToControl((Control)sep2, (Control)sep1, 128, 128, 0);
        Label sep3 = new Label((Composite)this, 0x1000000);
        sep3.setText("\"");
        sep3.setBackground(this.background);
        Widgets.attachToParent((Control)sep3, 16384, 100, -8);
        Widgets.attachToControl((Control)sep3, (Control)sep1, 128, 128, 0);
        this.degreesTxt = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.degreesTxt.setTextLimit(4);
        this.degreesTxt.setBackground(this.background);
        Widgets.attachToParent((Control)this.degreesTxt, 16384, 0, 2);
        Widgets.attachToControl((Control)this.degreesTxt, (Control)sep1, 131072, 16384, -2);
        Widgets.attachToControl((Control)this.degreesTxt, (Control)sep1, 128, 0x1000000, 0);
        this.minutesTxt = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.minutesTxt.setTextLimit(2);
        this.minutesTxt.setBackground(this.background);
        Widgets.attachToControl((Control)this.minutesTxt, (Control)sep1, 16384, 131072, 2);
        Widgets.attachToControl((Control)this.minutesTxt, (Control)sep2, 131072, 16384, -2);
        Widgets.attachToControl((Control)this.minutesTxt, (Control)sep1, 128, 0x1000000, 0);
        this.secondsTxt = new Text((Composite)this, 0x20004 | style & NO_BORDER_MASK);
        this.secondsTxt.setTextLimit(2);
        this.secondsTxt.setBackground(this.background);
        Widgets.attachToControl((Control)this.secondsTxt, (Control)sep2, 16384, 131072, 2);
        Widgets.attachToControl((Control)this.secondsTxt, (Control)sep3, 131072, 16384, -2);
        Widgets.attachToControl((Control)this.secondsTxt, (Control)sep1, 128, 0x1000000, 0);
        new Widgets.IntegerTextEntryHandler(this.degreesTxt, true, 4){

            @Override
            public void keyTraversed(TraverseEvent e) {
                try {
                    super.keyTraversed(e);
                    switch (e.detail) {
                        case 64: {
                            if (LatLongBox.this.degreesTxt.getCaretPosition() == LatLongBox.this.degreesTxt.getCharCount()) {
                                ((LatLongBox)LatLongBox.this).boxTabFlag[0] = false;
                                LatLongBox.this.minutesTxt.setFocus();
                            }
                            break;
                        }
                        case 16: {
                            ((LatLongBox)LatLongBox.this).boxTabFlag[0] = false;
                            break;
                        }
                        case 8: {
                            ((LatLongBox)LatLongBox.this).boxTabFlag[0] = true;
                        }
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                ((LatLongBox)LatLongBox.this).boxTabFlag[0] = true;
                if (!LatLongBox.this.hasFocus) {
                    LatLongBox.this.hasFocus = true;
                    LatLongBox.this.generateCompositeFocusEvent(e, 15);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    super.focusLost(e);
                    Control control = Display.getDefault().getCursorControl();
                    if (control != LatLongBox.this.minutesTxt && control != LatLongBox.this.secondsTxt && LatLongBox.this.boxTabFlag[0]) {
                        LatLongBox.this.hasFocus = false;
                        LatLongBox.this.generateCompositeFocusEvent(e, 16);
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void applyValue(long value) {
                try {
                    Long prevValue;
                    if (value > (long)LatLongBox.this.maxDegrees) {
                        value = LatLongBox.this.maxDegrees;
                        LatLongBox.this.degreesTxt.setText(Integer.toString(LatLongBox.this.maxDegrees));
                    } else if (value < (long)LatLongBox.this.minDegrees) {
                        value = LatLongBox.this.minDegrees;
                        LatLongBox.this.degreesTxt.setText(Integer.toString(LatLongBox.this.minDegrees));
                    }
                    if (value == (long)LatLongBox.this.maxDegrees) {
                        LatLongBox.this.minutesTxt.setText("0");
                        LatLongBox.this.secondsTxt.setText("0");
                    }
                    if (LatLongBox.this.minutesTxt.getText().equals("")) {
                        LatLongBox.this.minutesTxt.setText("0");
                    }
                    if (LatLongBox.this.secondsTxt.getText().equals("")) {
                        LatLongBox.this.secondsTxt.setText("0");
                    }
                    if ((prevValue = this.getPreviousValue()) == null) {
                        prevValue = Long.MIN_VALUE;
                    }
                    if (value != prevValue) {
                        double sign = value < 0L ? -1.0 : 1.0;
                        LatLongBox.this.dValue = (double)value + sign * ((double)Integer.parseInt(LatLongBox.this.minutesTxt.getText()) / 60.0 + (double)Integer.parseInt(LatLongBox.this.secondsTxt.getText()) / 3600.0);
                        System.out.println("latlong degrees changed: degrees = " + value + ", dValue=" + LatLongBox.this.dValue);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        };
        new Widgets.IntegerTextEntryHandler(this.minutesTxt, false, 2){

            @Override
            public void keyTraversed(TraverseEvent e) {
                try {
                    super.keyTraversed(e);
                    switch (e.detail) {
                        case 64: {
                            if (LatLongBox.this.minutesTxt.getCaretPosition() == LatLongBox.this.minutesTxt.getCharCount()) {
                                ((LatLongBox)LatLongBox.this).boxTabFlag[1] = false;
                                LatLongBox.this.secondsTxt.setFocus();
                            }
                            break;
                        }
                        case 32: {
                            if (LatLongBox.this.minutesTxt.getCaretPosition() == 0) {
                                LatLongBox.this.degreesTxt.setFocus();
                            }
                            ((LatLongBox)LatLongBox.this).boxTabFlag[1] = false;
                        }
                        case 16: {
                            ((LatLongBox)LatLongBox.this).boxTabFlag[1] = false;
                            break;
                        }
                        case 8: {
                            ((LatLongBox)LatLongBox.this).boxTabFlag[1] = false;
                        }
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                ((LatLongBox)LatLongBox.this).boxTabFlag[1] = true;
                if (!LatLongBox.this.hasFocus) {
                    LatLongBox.this.hasFocus = true;
                    LatLongBox.this.generateCompositeFocusEvent(e, 15);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    super.focusLost(e);
                    Control control = Display.getDefault().getCursorControl();
                    if (control != LatLongBox.this.degreesTxt && control != LatLongBox.this.secondsTxt && LatLongBox.this.boxTabFlag[1]) {
                        LatLongBox.this.hasFocus = false;
                        LatLongBox.this.generateCompositeFocusEvent(e, 16);
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void applyValue(long value) {
                try {
                    int degrees;
                    String dTxt = LatLongBox.this.degreesTxt.getText();
                    if (dTxt.equals("")) {
                        degrees = 0;
                        LatLongBox.this.degreesTxt.setText("0");
                    } else {
                        degrees = Integer.parseInt(dTxt);
                    }
                    if (degrees == LatLongBox.this.maxDegrees) {
                        value = 0L;
                    } else if (value > 59L) {
                        value = 59L;
                        LatLongBox.this.minutesTxt.setText(Integer.toString(59));
                    }
                    Long prevValue = this.getPreviousValue();
                    if (prevValue == null) {
                        prevValue = Long.MIN_VALUE;
                    }
                    if (value != prevValue) {
                        double sign = degrees < 0 ? -1.0 : 1.0;
                        String sTxt = LatLongBox.this.secondsTxt.getText();
                        if (sTxt.equals("")) {
                            LatLongBox.this.dValue = (double)degrees + sign * (double)value / 60.0;
                            LatLongBox.this.secondsTxt.setText("0");
                        } else {
                            LatLongBox.this.dValue = (double)degrees + sign * ((double)value / 60.0 + (double)Integer.parseInt(sTxt) / 3600.0);
                        }
                        System.out.println("latlong minutes changed: minutes = " + value + ", dValue=" + LatLongBox.this.dValue);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
        new Widgets.IntegerTextEntryHandler(this.secondsTxt, false, 2){

            @Override
            public void keyTraversed(TraverseEvent e) {
                super.keyTraversed(e);
                switch (e.detail) {
                    case 32: {
                        if (LatLongBox.this.secondsTxt.getCaretPosition() == 0) {
                            ((LatLongBox)LatLongBox.this).boxTabFlag[2] = false;
                            LatLongBox.this.minutesTxt.setFocus();
                        }
                    }
                    case 16: {
                        ((LatLongBox)LatLongBox.this).boxTabFlag[2] = true;
                        break;
                    }
                    case 8: {
                        ((LatLongBox)LatLongBox.this).boxTabFlag[2] = false;
                    }
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                ((LatLongBox)LatLongBox.this).boxTabFlag[2] = true;
                if (!LatLongBox.this.hasFocus) {
                    LatLongBox.this.hasFocus = true;
                    LatLongBox.this.generateCompositeFocusEvent(e, 15);
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    super.focusLost(e);
                    Control control = Display.getDefault().getCursorControl();
                    if (control != LatLongBox.this.minutesTxt && control != LatLongBox.this.degreesTxt && LatLongBox.this.boxTabFlag[2]) {
                        LatLongBox.this.hasFocus = false;
                        LatLongBox.this.generateCompositeFocusEvent(e, 16);
                    }
                }
                catch (RuntimeException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void applyValue(long value) {
                try {
                    int degrees;
                    String dTxt = LatLongBox.this.degreesTxt.getText();
                    if (dTxt.equals("")) {
                        degrees = 0;
                        LatLongBox.this.degreesTxt.setText("0");
                    } else {
                        degrees = Integer.parseInt(dTxt);
                    }
                    if (degrees == LatLongBox.this.maxDegrees) {
                        value = 0L;
                    } else if (value > 59L) {
                        value = 59L;
                        LatLongBox.this.secondsTxt.setText(Integer.toString(59));
                    }
                    Long prevValue = this.getPreviousValue();
                    if (prevValue == null) {
                        prevValue = Long.MIN_VALUE;
                    }
                    if (value != prevValue) {
                        double sign = degrees < 0 ? -1.0 : 1.0;
                        String mTxt = LatLongBox.this.minutesTxt.getText();
                        if (mTxt.equals("")) {
                            LatLongBox.this.dValue = (double)degrees + sign * (double)value / 3600.0;
                            LatLongBox.this.minutesTxt.setText("0");
                        } else {
                            LatLongBox.this.dValue = (double)degrees + sign * ((double)Integer.parseInt(mTxt) / 60.0 + (double)value / 3600.0);
                        }
                        System.out.println("latlong seconds changed: seconds = " + value + ", dValue=" + LatLongBox.this.dValue);
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void generateCompositeFocusEvent(FocusEvent e, int type) {
        Event event = new Event();
        event.display = e.display;
        event.time = e.time;
        event.data = e.data;
        event.widget = this;
        event.type = type;
        this.notifyListeners(type, event);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.setBackground(color);
            ++n2;
        }
        this.background = color;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            ctrl.setForeground(color);
            ++n2;
        }
    }

    public Double getValue() {
        return this.dValue;
    }

    public int getMinutes() {
        return Integer.parseInt(this.minutesTxt.getText());
    }

    public int getSeconds() {
        return Integer.parseInt(this.secondsTxt.getText());
    }

    public Color getBackground() {
        return this.background;
    }

    public int getMaxDegrees() {
        return this.maxDegrees;
    }

    public void setMaxDegrees(int maxDegrees) {
        this.maxDegrees = maxDegrees;
    }

    public int getMinDegrees() {
        return this.minDegrees;
    }

    public void setMinDegrees(int minDegrees) {
        this.minDegrees = minDegrees;
    }

    public String toString() {
        return String.format(String.valueOf(this.degreesTxt.getText()) + '\u00b0' + this.minutesTxt.getText() + "' " + this.secondsTxt.getText() + "\"", new Object[0]);
    }
}

