/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.osee.framework.ui.swt.CustomTableCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public abstract class EnumeratedCellEditor<T extends Enum<T>>
extends CustomTableCellEditor<T> {
    private final TableEditor editor;
    private final Table table;
    private final int columnIndex;
    private final int comboStyle;
    private final String toolTip;
    private final Class<T> clazz;
    private final String[] comboItems;
    private boolean enabled;
    private final Color color;
    private final EditCellListener tblListener = new EditCellListener();

    public EnumeratedCellEditor(Table table, int columnIndex, int comboStyle, String toolTip, Class<T> clazz) {
        this.table = table;
        this.columnIndex = columnIndex;
        this.comboStyle = comboStyle;
        this.toolTip = toolTip;
        this.clazz = clazz;
        this.enabled = true;
        this.comboItems = new String[((Enum[])clazz.getEnumConstants()).length];
        int i = 0;
        while (i < ((Enum[])clazz.getEnumConstants()).length) {
            this.comboItems[i] = ((Enum[])clazz.getEnumConstants())[i].toString();
            ++i;
        }
        this.editor = new TableEditor(table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.color = table.getDisplay().getSystemColor(1);
        table.addListener(3, (Listener)this.tblListener);
    }

    private int getIndexByText(String text) {
        int i = 0;
        while (i < this.comboItems.length) {
            if (text.equals(this.comboItems[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("No combo item matching text: " + text);
    }

    @Override
    protected abstract T applyValue(int var1, T var2, T var3);

    @Override
    protected abstract T focusLost(int var1, T var2, T var3);

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        if (enabled) {
            this.table.addListener(3, (Listener)this.tblListener);
            this.enabled = true;
        } else {
            this.table.removeListener(3, (Listener)this.tblListener);
            this.enabled = false;
        }
    }

    private final class EditCellListener
    implements Listener {
        private EditCellListener() {
        }

        public void handleEvent(Event event) {
            Point pt = new Point(event.x, event.y);
            int index = EnumeratedCellEditor.this.table.getTopIndex();
            while (index < EnumeratedCellEditor.this.table.getItemCount()) {
                final int rowIndex = index;
                final TableItem item = EnumeratedCellEditor.this.table.getItem(index);
                Rectangle rect = item.getBounds(EnumeratedCellEditor.this.columnIndex);
                if (rect.contains(pt)) {
                    final Enum oldValue = ((Enum[])EnumeratedCellEditor.this.clazz.getEnumConstants())[EnumeratedCellEditor.this.getIndexByText(item.getText(EnumeratedCellEditor.this.columnIndex))];
                    final CCombo combo = new CCombo((Composite)EnumeratedCellEditor.this.table, EnumeratedCellEditor.this.comboStyle);
                    combo.setBackground(EnumeratedCellEditor.this.color);
                    combo.setItems(EnumeratedCellEditor.this.comboItems);
                    combo.setToolTipText(EnumeratedCellEditor.this.toolTip);
                    Listener textListener = new Listener(){

                        public void handleEvent(Event e) {
                            Enum value = ((Enum[])EnumeratedCellEditor.this.clazz.getEnumConstants())[combo.getSelectionIndex()];
                            switch (e.type) {
                                case 16: {
                                    item.setText(EnumeratedCellEditor.this.columnIndex, EnumeratedCellEditor.this.focusLost(rowIndex, value, oldValue).toString());
                                    combo.dispose();
                                    break;
                                }
                                case 31: {
                                    switch (e.detail) {
                                        case 4: {
                                            item.setText(EnumeratedCellEditor.this.columnIndex, EnumeratedCellEditor.this.applyValue(rowIndex, value, oldValue).toString());
                                        }
                                        case 2: {
                                            combo.dispose();
                                            e.doit = false;
                                        }
                                    }
                                    break;
                                }
                                case 13: {
                                    item.setText(EnumeratedCellEditor.this.columnIndex, EnumeratedCellEditor.this.applyValue(rowIndex, value, oldValue).toString());
                                    combo.dispose();
                                }
                            }
                        }
                    };
                    combo.addListener(16, textListener);
                    combo.addListener(31, textListener);
                    combo.addListener(13, textListener);
                    combo.select(oldValue.ordinal());
                    EnumeratedCellEditor.this.editor.setEditor((Control)combo, item, EnumeratedCellEditor.this.columnIndex);
                    combo.setFocus();
                    return;
                }
                ++index;
            }
        }
    }
}

