/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.client.AccessTopicEvent;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.users.BootStrapUser;

public class CurrentUserProvider
extends LazyObject<User> {
    private final LazyObject<Cache<String, User>> cacheProvider;
    private final AtomicBoolean duringCreateUser = new AtomicBoolean(false);
    private final AtomicBoolean isAnonymousAuthenticationAllowed = new AtomicBoolean(true);
    private final AtomicBoolean isAnonymousNotificationAllowed = new AtomicBoolean(true);

    public CurrentUserProvider(LazyObject<Cache<String, User>> cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    protected FutureTask<User> createLoaderTask() {
        this.duringCreateUser.set(false);
        CurrentUserCreationCallable callable = new CurrentUserCreationCallable();
        return new FutureTask<User>(callable);
    }

    public boolean isDuringCurrentUserCreation() {
        return this.duringCreateUser.get();
    }

    private final class CurrentUserCreationCallable
    implements Callable<User> {
        private CurrentUserCreationCallable() {
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public User call() throws Exception {
            void var1_6;
            block9: {
                block10: {
                    Object var1_1 = null;
                    ClientSessionManager.ensureSessionCreated();
                    if (!ClientSessionManager.isSessionValid()) break block10;
                    String userId = ClientSessionManager.getSession().getUserId();
                    if (SystemUser.BootStrap.getUserId().equals(userId)) {
                        BootStrapUser bootStrapUser = BootStrapUser.getInstance();
                        break block9;
                    } else {
                        UserToken currentUserToken = ClientSessionManager.getCurrentUserToken();
                        try {
                            User user = this.getUser(currentUserToken);
                        }
                        catch (UserNotInDatabase userNotInDatabase) {
                            if (CurrentUserProvider.this.isAnonymousAuthenticationAllowed.compareAndSet(true, false)) {
                                ClientSessionManager.authenticateAsAnonymous();
                                User user = this.getUser(SystemUser.Anonymous);
                            }
                            break block9;
                        }
                    }
                }
                if (CurrentUserProvider.this.isAnonymousAuthenticationAllowed.compareAndSet(true, false)) {
                    ClientSessionManager.authenticateAsAnonymous();
                    User user = this.getUser(SystemUser.Anonymous);
                }
            }
            if (var1_6 == null) {
                throw new OseeStateException("Setting current user to null.", new Object[0]);
            }
            if (var1_6.equals(SystemUser.Anonymous) && CurrentUserProvider.this.isAnonymousNotificationAllowed.compareAndSet(true, false)) {
                OseeLog.log(Activator.class, (Level)Level.INFO, (String)"You are logged into OSEE as \"Anonymous\".  If this is unexpected notify your OSEE admin");
            }
            if (ClientSessionManager.isSessionValid()) {
                AccessTopicEventPayload payload = new AccessTopicEventPayload();
                OseeEventManager.kickAccessTopicEvent(CurrentUserCreationCallable.class, payload, AccessTopicEvent.USER_AUTHENTICATED);
            }
            return var1_6;
        }

        private User getUser(UserToken token) {
            User user = null;
            try {
                user = (User)((Object)((Cache)CurrentUserProvider.this.cacheProvider.get()).get((Object)token.getUserId()));
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
            return user;
        }
    }
}

