/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.BranchType;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;
import org.eclipse.osee.orcs.rest.model.NewBranch;

public final class CreateBranchHttpRequestOperation
extends AbstractOperation {
    private final BranchType branchType;
    private final TransactionToken parentTransaction;
    private final String branchName;
    private final ArtifactId associatedArtifact;
    private final String creationComment;
    private final int mergeAddressingQueryId;
    private final BranchId destinationBranch;
    private BranchToken newBranch;
    private boolean txCopyBranchType;
    private final BranchId branch;

    public CreateBranchHttpRequestOperation(BranchType branchType, TransactionToken parentTransaction, BranchToken branch, ArtifactId associatedArtifact, String creationComment) {
        this(branchType, parentTransaction, branch, associatedArtifact, creationComment, -1, BranchId.SENTINEL);
    }

    public CreateBranchHttpRequestOperation(BranchType branchType, TransactionToken parentTransaction, BranchToken branch, ArtifactId associatedArtifact, String creationComment, int mergeAddressingQueryId, BranchId destinationBranch) {
        super("Create branch " + branch.getName(), "org.eclipse.osee.framework.skynet.core");
        this.branchType = branchType;
        this.parentTransaction = parentTransaction;
        this.branchName = branch.getName();
        this.branch = branch;
        this.associatedArtifact = associatedArtifact;
        this.creationComment = creationComment;
        this.mergeAddressingQueryId = mergeAddressingQueryId;
        this.destinationBranch = destinationBranch;
        this.txCopyBranchType = false;
    }

    protected void doWork(IProgressMonitor monitor) {
        BranchEndpoint branchEndpoint = ServiceUtil.getOseeClient().getBranchEndpoint();
        NewBranch data = new NewBranch();
        data.setAssociatedArtifact(this.associatedArtifact != null && this.associatedArtifact.isValid() ? this.associatedArtifact : ArtifactId.SENTINEL);
        data.setAuthor((ArtifactId)UserManager.getUser());
        data.setBranchName(this.branchName);
        data.setBranchType(this.branchType);
        data.setCreationComment(this.creationComment);
        data.setMergeAddressingQueryId(this.mergeAddressingQueryId);
        data.setMergeDestinationBranchId(this.destinationBranch);
        data.setParentBranchId(this.parentTransaction.getBranch());
        data.setSourceTransactionId(this.parentTransaction);
        data.setTxCopyBranchType(this.isTxCopyBranchType());
        BranchId response = this.branch.isValid() ? branchEndpoint.createBranchWithId(this.branch, data) : branchEndpoint.createBranch(data);
        this.newBranch = this.getBranchWithCacheWorkAround(response);
        OseeEventManager.kickBranchEvent(((Object)((Object)this)).getClass(), new BranchEvent(BranchEventType.Added, (BranchId)this.newBranch));
    }

    private BranchToken getBranchWithCacheWorkAround(BranchId branch) {
        return BranchManager.getBranchToken(branch);
    }

    public BranchToken getNewBranch() {
        return this.newBranch;
    }

    public boolean isTxCopyBranchType() {
        return this.txCopyBranchType;
    }

    public void setTxCopyBranchType(boolean value) {
        this.txCopyBranchType = value;
    }
}

