/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.commit.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.commit.actions.CommitAction;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;

public class CatchArtifactChanges
implements CommitAction {
    @Override
    public void runCommitAction(BranchId sourceBranch, BranchId destinationBranch) {
        ArrayList<Change> changes = new ArrayList<Change>();
        IOperation operation = ChangeManager.compareTwoBranchesHead(sourceBranch, destinationBranch, changes);
        Operations.executeWorkAndCheckStatus((IOperation)operation);
        HashSet<Integer> orphanedArts = new HashSet<Integer>();
        HashSet<Integer> shouldBeDeletedArts = new HashSet<Integer>();
        for (Change change : changes) {
            Artifact artifactChanged = change.getChangeArtifact();
            if (!artifactChanged.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractImplementationDetails, CoreArtifactTypes.AbstractSoftwareRequirement})) continue;
            if (artifactChanged.isDeleted()) {
                this.checkArtIsFullyDeleted(shouldBeDeletedArts, artifactChanged);
                continue;
            }
            this.checkForOrphans(orphanedArts, artifactChanged);
        }
        String err = null;
        if (!orphanedArts.isEmpty()) {
            err = String.format("Commit Branch Failed. The following artifacts are orphaned.  Please appropriately parent the artifact, then recommit : [%s]\n\n", ((Object)orphanedArts).toString());
        }
        if (!shouldBeDeletedArts.isEmpty()) {
            String temp = String.format("Commit Branch Failed. The following artifacts are deleted but still have relations.  Please remove the relations, then recommit : [%s]\n\n", ((Object)shouldBeDeletedArts).toString());
            String string = err = err == null ? temp : String.valueOf(err) + temp;
        }
        if (err != null) {
            throw new OseeCoreException(err, new Object[0]);
        }
    }

    private void checkArtIsFullyDeleted(Set<Integer> shouldBeDeletedArts, Artifact artifactChanged) {
        Artifact relatedArt = artifactChanged.getRelatedArtifactOrNull(CoreRelationTypes.DefaultHierarchical_Parent);
        if (relatedArt != null) {
            shouldBeDeletedArts.add(artifactChanged.getArtId());
        }
    }

    private void checkForOrphans(Set<Integer> orphanedArts, Artifact artifactChanged) {
        Artifact relatedArt = artifactChanged.getRelatedArtifactOrNull(CoreRelationTypes.DefaultHierarchical_Parent);
        if (relatedArt == null) {
            orphanedArts.add(artifactChanged.getArtId());
        }
    }
}

