/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.IAttribute;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.messaging.event.res.AttributeEventModificationType;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.eclipse.osee.framework.skynet.core.attribute.providers.IAttributeDataProvider;
import org.eclipse.osee.framework.skynet.core.event.model.AttributeChange;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;

public abstract class Attribute<T>
implements Comparable<Attribute<T>>,
IAttribute<T> {
    private WeakReference<Artifact> artifactRef;
    private IAttributeDataProvider attributeDataProvider;
    private AttributeId attrId = AttributeId.SENTINEL;
    private GammaId gammaId = GammaId.SENTINEL;
    private boolean dirty;
    private ModificationType modificationType;
    private boolean useBackingData;
    private AttributeTypeId attributeTypeToken;
    private ApplicabilityId applicabilityId;

    void internalInitialize(AttributeTypeId attributeType, Artifact artifact, ModificationType modificationType, ApplicabilityId applicabilityId, boolean markDirty, boolean setDefaultValue) {
        this.attributeTypeToken = attributeType;
        this.artifactRef = new WeakReference<Artifact>(artifact);
        this.internalSetModType(modificationType, false, markDirty);
        if (applicabilityId == null) {
            this.internalSetApplicabilityId(ApplicabilityId.BASE);
        } else {
            this.internalSetApplicabilityId(applicabilityId);
        }
        try {
            this.attributeDataProvider = AttributeTypeManager.getAttributeProvider(attributeType.getId(), this);
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        if (setDefaultValue) {
            this.setToDefaultValue();
        }
        this.uponInitialize();
    }

    private void internalSetApplicabilityId(ApplicabilityId applicabilityId) {
        this.applicabilityId = applicabilityId;
    }

    protected void uponInitialize() {
    }

    public AttributeChange createAttributeChangeFromSelf() {
        AttributeChange attributeChange = new AttributeChange();
        attributeChange.setAttrTypeGuid(this.getAttributeType().getId());
        attributeChange.setGammaId(this.gammaId);
        attributeChange.setAttributeId(this.attrId.getId().intValue());
        attributeChange.setModTypeGuid(AttributeEventModificationType.getType((ModificationType)this.modificationType).getGuid());
        Object[] objectArray = this.attributeDataProvider.getData();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj == null) {
                attributeChange.getData().add("");
            } else {
                attributeChange.getData().add(obj);
            }
            ++n2;
        }
        return attributeChange;
    }

    public void internalInitialize(AttributeTypeId attributeType, Artifact artifact, ModificationType modificationType, ApplicabilityId applicabilityId, AttributeId attributeId, GammaId gammaId, boolean markDirty, boolean setDefaultValue) {
        this.internalInitialize(attributeType, artifact, modificationType, applicabilityId, markDirty, setDefaultValue);
        this.attrId = attributeId;
        this.gammaId = gammaId;
    }

    protected void markAsNewOrChanged() {
        if (this.isInDb()) {
            this.internalSetModType(ModificationType.MODIFIED, false, true);
        } else {
            this.internalSetModType(ModificationType.NEW, false, true);
        }
    }

    public boolean setValue(T value) {
        Conditions.checkNotNull(value, (String)"Attribute value", (String)"attribute id [%s]", (Object[])new Object[]{this.getId()});
        this.checkIsRenameable(value);
        boolean response = this.subClassSetValue(value);
        if (response) {
            this.markAsNewOrChanged();
        }
        return response;
    }

    protected boolean setFromStringNoDirty(String value) {
        Conditions.checkNotNull((Object)value, (String)"Attribute value", (String)"attribute id [%s]", (Object[])new Object[]{this.getId()});
        return this.subClassSetValue(this.convertStringToValue(value));
    }

    public boolean setFromString(String value) {
        Conditions.checkNotNull((Object)value, (String)"Attribute value", (String)"attribute id [%s]", (Object[])new Object[]{this.getId()});
        return this.setValue(this.convertStringToValue(value));
    }

    private void checkIsRenameable(T value) {
        XResultData results;
        if (this.getAttributeType().equals(CoreAttributeTypes.Name) && !value.equals(this.getValue()) && (results = ServiceUtil.getOseeClient().getAccessControlService().isRenamable(Collections.singleton(this.getArtifact()), new XResultData())).isErrors()) {
            throw new OseeStateException(results.toString(), new Object[0]);
        }
    }

    public abstract T convertStringToValue(String var1);

    public String convertToStorageString(T rawValue) {
        return rawValue == null ? null : rawValue.toString();
    }

    public final void resetToDefaultValue() {
        this.setToDefaultValue();
    }

    protected void setToDefaultValue() {
        AttributeTypeGeneric<?> attributeType = AttributeTypeManager.getAttributeType(this.attributeTypeToken.getId());
        Object defaultValue = this.getArtifact().getArtifactType().getAttributeDefault(attributeType);
        if (defaultValue != null) {
            this.subClassSetValue(defaultValue);
        }
    }

    public boolean setValueFromInputStream(InputStream value) {
        try {
            boolean response = this.setFromString(Lib.inputStreamToString((InputStream)value));
            if (response) {
                this.markAsNewOrChanged();
            }
            return response;
        }
        catch (IOException ex) {
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    protected abstract boolean subClassSetValue(T var1);

    public String getDisplayableString() {
        return this.getAttributeDataProvider().getDisplayableString();
    }

    public String toString() {
        try {
            return this.getDisplayableString();
        }
        catch (OseeCoreException ex) {
            return Lib.exceptionToString((Exception)((Object)ex));
        }
    }

    public IAttributeDataProvider getAttributeDataProvider() {
        return this.attributeDataProvider;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setNotDirty() {
        this.setDirtyFlag(false);
    }

    private void setDirtyFlag(boolean dirty) {
        this.dirty = dirty;
        ArtifactCache.updateCachedArtifact(this.getArtifact());
    }

    public Artifact getArtifact() {
        if (this.artifactRef.get() == null) {
            throw new OseeStateException("Artifact has been garbage collected", new Object[0]);
        }
        return (Artifact)((Object)this.artifactRef.get());
    }

    public String getNameValueDescription() {
        return String.valueOf(this.getAttributeType().getName()) + ": " + this.toString();
    }

    public AttributeTypeToken getAttributeType() {
        return AttributeTypeManager.getAttributeType(this.attributeTypeToken.getId());
    }

    public AttributeTypeId getAttributeTypeToken() {
        return this.attributeTypeToken;
    }

    public boolean isOfType(AttributeTypeId otherAttributeType) {
        return this.attributeTypeToken.equals(otherAttributeType);
    }

    public void resetModType() {
        this.internalSetModType(ModificationType.MODIFIED, false, true);
    }

    public final void setArtifactDeleted() {
        this.internalSetModType(ModificationType.ARTIFACT_DELETED, true, true);
    }

    public final void delete() {
        if (this.isInDb()) {
            this.internalSetModType(ModificationType.DELETED, true, true);
        } else {
            this.getArtifact().deleteAttribute(this);
        }
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public boolean canDelete() {
        try {
            AttributeTypeToken attributeType = this.getAttributeType();
            return this.getArtifact().getAttributeCount((AttributeTypeId)attributeType) > ((Artifact)((Object)this.artifactRef.get())).getArtifactType().getMin(attributeType);
        }
        catch (OseeCoreException oseeCoreException) {
            return false;
        }
    }

    void purge() {
        this.getAttributeDataProvider().purge();
    }

    public void markAsPurged() {
        this.internalSetModType(ModificationType.DELETED, false, false);
    }

    public boolean isInDb() {
        return this.getGammaId().isValid();
    }

    public Long getId() {
        return this.attrId.getId();
    }

    public GammaId getGammaId() {
        return this.gammaId;
    }

    public ApplicabilityId getApplicabilityId() {
        return this.applicabilityId;
    }

    public void internalSetGammaId(GammaId gammaId) {
        this.gammaId = gammaId;
    }

    public void internalSetAttributeId(AttributeId attrId) {
        this.attrId = attrId;
    }

    public boolean isDeleted() {
        try {
            return this.modificationType.isDeleted();
        }
        catch (NullPointerException ex) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Unexpected null modification type for artifact attribute [%d] gamma [%d] on artifact [%s]", (Object[])new Object[]{this.getId(), this.getGammaId(), this.getArtifact().getSafeName()});
            return false;
        }
    }

    public void replaceWithVersion(GammaId gammaId) {
        this.internalSetPersistenceData(gammaId, ModificationType.REPLACED_WITH_VERSION);
    }

    private void internalSetPersistenceData(GammaId gammaId, ModificationType modType) {
        this.internalSetModType(modType, true, true);
        this.internalSetGammaId(gammaId);
    }

    public void introduce(Attribute<?> sourceAttr) {
        this.internalSetPersistenceData(sourceAttr.getGammaId(), sourceAttr.getModificationType());
    }

    public boolean isUseBackingData() {
        return this.useBackingData;
    }

    public void internalSetModType(ModificationType modificationType, boolean useBackingData, boolean dirty) {
        this.modificationType = modificationType;
        this.useBackingData = useBackingData;
        this.setDirtyFlag(dirty);
    }

    @Override
    public int compareTo(Attribute<T> other) {
        return this.toString().compareTo(other.toString());
    }
}

