/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.IBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.cache.ArtifactIdCache;

public final class ArtifactCache {
    private static final ArtifactIdCache ID_CACHE = new ArtifactIdCache(2000);

    private ArtifactCache() {
    }

    static void cache(Artifact artifact) {
        if (!artifact.isHistorical()) {
            ID_CACHE.cache(artifact);
        }
    }

    public static void deCache(Artifact artifact) {
        if (!artifact.isHistorical()) {
            ID_CACHE.deCache(artifact);
        }
    }

    public static void deCache(BranchId branch) {
        for (Artifact artifact : ID_CACHE.getAll()) {
            if (!artifact.isOnBranch(branch)) continue;
            ID_CACHE.deCache(artifact);
        }
    }

    public static String report() {
        StringBuilder sb = new StringBuilder();
        sb.append("Active:");
        sb.append(ID_CACHE.toString());
        return sb.toString();
    }

    public static Collection<Artifact> getDirtyArtifacts() {
        return ID_CACHE.getAllDirties();
    }

    public static void updateCachedArtifact(ArtifactToken artifact) {
        ID_CACHE.updateReferenceType(artifact);
    }

    public static List<Artifact> getArtifactsByType(ArtifactTypeToken artifactType) {
        LinkedList<Artifact> artifacts = new LinkedList<Artifact>();
        for (Artifact artifact : ID_CACHE.getAll()) {
            if (!artifact.isOfType(new ArtifactTypeId[]{artifactType})) continue;
            artifacts.add(artifact);
            ArtifactCache.deCache(artifact);
        }
        return artifacts;
    }

    public static Collection<Artifact> getActive(Collection<? extends DefaultBasicGuidArtifact> basicGuidArtifacts) {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (DefaultBasicGuidArtifact defaultBasicGuidArtifact : basicGuidArtifacts) {
            Artifact art = ID_CACHE.getByGuid((String)defaultBasicGuidArtifact.getGuid(), defaultBasicGuidArtifact.getBranch());
            if (art == null) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    public static Artifact getActive(DefaultBasicGuidArtifact guidArt) {
        return ArtifactCache.getActive((String)guidArt.getGuid(), guidArt.getBranch());
    }

    private static Artifact getActiveA(IBasicGuidRelation guidRel) {
        return ArtifactCache.getActive((String)guidRel.getArtA().getGuid(), guidRel.getArtA().getBranch());
    }

    private static Artifact getActiveB(IBasicGuidRelation guidRel) {
        return ArtifactCache.getActive((String)guidRel.getArtB().getGuid(), guidRel.getArtB().getBranch());
    }

    public static Collection<Artifact> getActive(IBasicGuidRelation guidRel) {
        return ArtifactCache.getActive(guidRel, null);
    }

    public static <A extends Artifact> Collection<A> getActive(IBasicGuidRelation guidRel, Class<A> clazz) {
        Artifact artB;
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        Artifact artA = ArtifactCache.getActiveA(guidRel);
        if (artA != null && (clazz == null || clazz.isInstance((Object)artA))) {
            arts.add(artA);
        }
        if ((artB = ArtifactCache.getActiveB(guidRel)) != null && (clazz == null || clazz.isInstance((Object)artB))) {
            arts.add(artB);
        }
        return arts;
    }

    public static Artifact getActive(ArtifactId artId, BranchId branch) {
        return ArtifactCache.getActive(ArtifactToken.valueOf((ArtifactId)artId, (BranchId)branch));
    }

    public static Artifact getActive(ArtifactToken artifact) {
        return ID_CACHE.getById(artifact);
    }

    public static Artifact getActive(String artGuid, BranchId branch) {
        return ID_CACHE.getByGuid(artGuid, branch);
    }

    public static Artifact getActive(Long artId, BranchId branch) {
        return ArtifactCache.getActive(ArtifactToken.valueOf((long)artId, (BranchId)branch));
    }
}

