/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.internal.http;

import io.restassured.http.Method;
import io.restassured.internal.assertion.AssertParameter;
import io.restassured.internal.http.CustomHttpMethod;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;

public class HttpRequestFactory {
    private static final Map<String, Class<? extends HttpRequestBase>> HTTP_METHOD_TO_HTTP_REQUEST_TYPE = new HashMap<String, Class<? extends HttpRequestBase>>(){
        {
            this.put(Method.PUT.name(), HttpPut.class);
            this.put(Method.POST.name(), HttpPost.class);
            this.put(Method.PATCH.name(), HttpPatch.class);
        }
    };

    static HttpRequestBase createHttpRequest(URI uri, String httpMethod) {
        Object httpRequest;
        String method = AssertParameter.notNull(StringUtils.upperCase((String)StringUtils.trimToNull((String)httpMethod)), "Http method");
        Class<? extends HttpRequestBase> type = HTTP_METHOD_TO_HTTP_REQUEST_TYPE.get(method);
        if (type == null) {
            httpRequest = new CustomHttpMethod(method, uri);
        } else {
            try {
                httpRequest = type.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            httpRequest.setURI(uri);
        }
        return httpRequest;
    }
}

