/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.ServiceUtil;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchButtonAbstract;
import org.eclipse.osee.framework.core.access.AccessControlData;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.client.AccessTopicEvent;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.IUserGroup;
import org.eclipse.osee.framework.core.enums.CoreUserGroups;
import org.eclipse.osee.framework.core.enums.PermissionEnum;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class XWorkingBranchButtonLock
extends XWorkingBranchButtonAbstract
implements EventHandler {
    public static String WIDGET_NAME = "XWorkingBranchButtonLock";

    @Override
    protected void initButton(final Button button) {
        button.setToolTipText("Toggle Working Branch Access Control");
        button.addListener(13, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event e) {
                XWorkingBranchButtonLock.this.toggleWorkingBranchLock(button);
            }
        });
    }

    @Override
    protected void refreshEnablement(Button button) {
        button.setEnabled(!this.disableAll && this.isWorkingBranchInWork() && !this.isCommittedBranchExists() && this.isWidgetAllowedInCurrentState());
        this.refreshLockImage(button);
    }

    private void refreshLockImage(Button button) {
        boolean noBranch = false;
        boolean someAccessControlSet = false;
        BranchId branch = BranchId.SENTINEL;
        try {
            branch = this.getTeamArt().getWorkingBranch();
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
        if (branch.isInvalid()) {
            noBranch = true;
        } else {
            someAccessControlSet = !ServiceUtil.getOseeClient().getAccessControlService().getAccessControlList((Object)branch).isEmpty();
        }
        button.setImage(ImageManager.getImage((KeyedImage)(noBranch || someAccessControlSet ? FrameworkImage.LOCK_LOCKED : FrameworkImage.LOCK_UNLOCKED)));
        button.redraw();
        button.getParent().redraw();
    }

    private void toggleWorkingBranchLock(Button button) {
        try {
            BranchToken branch = this.getTeamArt().getWorkingBranch();
            if (branch.isInvalid()) {
                AWorkbench.popup((String)"Working branch doesn't exist");
                return;
            }
            boolean isLocked = false;
            boolean manuallyLocked = false;
            List datas = AtsApiService.get().getAccessControlService().getAccessControlList((Object)branch);
            if (datas.size() > 1) {
                manuallyLocked = true;
            } else if (datas.isEmpty()) {
                isLocked = false;
            } else {
                AccessControlData data = (AccessControlData)datas.iterator().next();
                if (data.getSubject().equals(CoreUserGroups.Everyone) && data.getBranchPermission().equals((Object)PermissionEnum.READ)) {
                    isLocked = true;
                } else {
                    manuallyLocked = true;
                }
            }
            if (manuallyLocked) {
                AWorkbench.popup((String)"Manual access control applied to branch.  Can't override.\n\nUse Access Control option of Branch Manager");
                return;
            }
            String message = String.format("Working branch is currently [%s]\n\n%s the Branch?", isLocked ? "Locked" : "NOT Locked", isLocked ? "UnLock" : "Lock");
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Toggle Branch Lock", (String)message)) {
                if (isLocked) {
                    AtsApiService.get().getAccessControlService().removeAccessControlDataIf(true, (AccessControlData)datas.iterator().next());
                } else {
                    IUserGroup everyoneGroup = AtsApiService.get().userService().getUserGroup(CoreUserGroups.Everyone);
                    Conditions.assertTrue((boolean)(everyoneGroup.getArtifact() instanceof Artifact), (String)"Must be Artifact", (Object[])new Object[0]);
                    AtsApiService.get().getAccessControlService().setPermission(everyoneGroup.getArtifact(), (BranchId)branch, PermissionEnum.READ);
                }
                AWorkbench.popup((String)String.format("Branch set to [%s]", !isLocked ? "Locked" : "NOT Locked"));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public void handleEvent(Event event) {
        AccessTopicEventPayload accessEvent;
        BranchToken branch = this.getTeamArt().getWorkingBranch();
        if (branch.isValid() && branch.equals((accessEvent = (AccessTopicEventPayload)EventUtil.getTopicJson((Event)event, AccessTopicEventPayload.class)).getBranch())) {
            this.refreshWorkingBranchWidget();
        }
    }

    @Override
    protected void createControls(Composite parent, int horizontalSpan) {
        super.createControls(parent, horizontalSpan);
        BundleContext context = AtsApiService.get().getEventService().getBundleContext("org.eclipse.osee.ats.ide");
        context.registerService(EventHandler.class.getName(), (Object)this, AtsUtil.hashTable((String)"event.topics", (String)AccessTopicEvent.ACCESS_BRANCH_MODIFIED.getTopic()));
    }

    @Override
    protected boolean isWidgetAllowedInCurrentState() {
        return this.isWidgetInState(WIDGET_NAME);
    }
}

