/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.internal;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.config.AtsConfigEndpointApi;
import org.eclipse.osee.ats.api.config.AtsConfigurations;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsServerEndpointProvider;
import org.eclipse.osee.ats.api.version.Version;
import org.eclipse.osee.ats.core.config.AbstractAtsConfigurationService;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public class AtsConfigurationsService
extends AbstractAtsConfigurationService {
    private Supplier<AtsConfigurations> configurationsCache;

    public AtsConfigurations getConfigurations() {
        if (this.configurationsCache == null || ((AtsConfigurations)this.configurationsCache.get()).getUsers().isEmpty()) {
            this.invalidate();
        }
        return (AtsConfigurations)this.configurationsCache.get();
    }

    public AtsConfigurations getConfigurationsWithPend() {
        this.invalidate();
        AtsConfigurations configs = (AtsConfigurations)this.configurationsCache.get();
        return configs;
    }

    private void invalidate() {
        this.configurationsCache = Suppliers.memoizeWithExpiration(this.getConfigurationsSupplier(), (long)30L, (TimeUnit)TimeUnit.MINUTES);
    }

    private Supplier<AtsConfigurations> getConfigurationsSupplier() {
        return new Supplier<AtsConfigurations>(){

            public AtsConfigurations get() {
                return AtsConfigurationsService.this.loadConfigurations();
            }
        };
    }

    private AtsConfigurations loadConfigurations() {
        AtsApiIde iAtsClient = AtsApiService.get();
        if (iAtsClient != null) {
            IAtsServerEndpointProvider serverEndpoints = iAtsClient.getServerEndpoints();
            AtsConfigEndpointApi configEndpoint = serverEndpoints.getConfigEndpoint();
            AtsConfigurations configs = configEndpoint.get();
            for (Version version : configs.getIdToVersion().values()) {
                version.setAtsApi((AtsApi)AtsApiService.get());
            }
            for (TeamDefinition teamDef : configs.getIdToTeamDef().values()) {
                teamDef.setAtsApi((AtsApi)AtsApiService.get());
            }
            for (ActionableItem ai : configs.getIdToAi().values()) {
                ai.setAtsApi(this.atsApi);
            }
            for (AtsUser user : configs.getUsers()) {
                user.setAtsApi((AtsApi)AtsApiService.get());
            }
            return configs;
        }
        return new AtsConfigurations();
    }

    public XResultData configAtsDatabase(AtsApi atsApi) {
        if (this.isAtsBaseCreated()) {
            XResultData results = new XResultData();
            results.error("ATS base config has already been completed");
            return results;
        }
        return AtsApiService.get().getServerEndpoints().getConfigEndpoint().atsDbInit();
    }

    public synchronized AtsUser getUserByLoginId(String loginId) {
        AtsUser user = AtsApiService.get().getServerEndpoints().getConfigEndpoint().getUserByLogin(loginId);
        user.setStoreObject(ArtifactToken.valueOf((long)user.getId(), (BranchId)this.atsApi.getAtsBranch()));
        user.setAtsApi(this.atsApi);
        return user;
    }

    public boolean isConfigLoaded() {
        return this.atsConfigurations != null;
    }

    public AtsUser getCurrentUserByLoginId() {
        return this.getUserByLoginId(System.getProperty("user.name"));
    }
}

